/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

class KllDirectCompactDoublesSketch
extends KllDirectDoublesSketch {
    KllDirectCompactDoublesSketch(Memory srcMem, KllMemoryValidate memVal) {
        super((WritableMemory)srcMem, null, memVal);
    }

    @Override
    public long getN() {
        if (KllPreambleUtil.getMemoryEmptyFlag((Memory)this.wmem)) {
            return 0L;
        }
        if (KllPreambleUtil.getMemorySingleItemFlag((Memory)this.wmem)) {
            return 1L;
        }
        return KllPreambleUtil.getMemoryN((Memory)this.wmem);
    }

    @Override
    public byte[] toByteArray() {
        int bytes = (int)this.wmem.getCapacity();
        byte[] byteArr = new byte[bytes];
        this.wmem.getByteArray(0L, byteArr, 0, bytes);
        return byteArr;
    }

    @Override
    double[] getDoubleItemsArray() {
        int k = this.getK();
        if (this.isEmpty()) {
            return new double[k];
        }
        if (this.isSingleItem()) {
            double[] itemsArr = new double[k];
            itemsArr[k - 1] = this.wmem.getDouble(8L);
            return itemsArr;
        }
        int capacityItems = this.levelsArr[this.getNumLevels()];
        double[] itemsArr = new double[capacityItems];
        int levelsBytes = (this.levelsArr.length - 1) * 4;
        int offset = 20 + levelsBytes + 16;
        int shift = this.levelsArr[0];
        this.wmem.getDoubleArray((long)offset, itemsArr, shift, capacityItems - shift);
        return itemsArr;
    }

    @Override
    double getDoubleSingleItem() {
        if (!this.isSingleItem()) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.NOT_SINGLE_ITEM);
        }
        return this.wmem.getDouble(8L);
    }

    @Override
    double getMaxDoubleValue() {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        if (this.isSingleItem()) {
            return this.getDoubleSingleItem();
        }
        int offset = 20 + (this.getLevelsArray().length - 1) * 4 + 8;
        return this.wmem.getDouble((long)offset);
    }

    @Override
    double getMinDoubleValue() {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        if (this.isSingleItem()) {
            return this.getDoubleSingleItem();
        }
        int offset = 20 + (this.getLevelsArray().length - 1) * 4;
        return this.wmem.getDouble((long)offset);
    }
}

