/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.Matrices;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.rdd.RDD;

public class JavaHypothesisTestingExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaHypothesisTestingExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        Vector vec = Vectors.dense((double)0.1, (double[])new double[]{0.15, 0.2, 0.3, 0.25});
        ChiSqTestResult goodnessOfFitTestResult = Statistics.chiSqTest((Vector)vec);
        System.out.println(goodnessOfFitTestResult + "\n");
        Matrix mat = Matrices.dense((int)3, (int)2, (double[])new double[]{1.0, 3.0, 5.0, 2.0, 4.0, 6.0});
        ChiSqTestResult independenceTestResult = Statistics.chiSqTest((Matrix)mat);
        System.out.println(independenceTestResult + "\n");
        JavaRDD obs = jsc.parallelize(Arrays.asList(new LabeledPoint(1.0, Vectors.dense((double)1.0, (double[])new double[]{0.0, 3.0})), new LabeledPoint(1.0, Vectors.dense((double)1.0, (double[])new double[]{2.0, 0.0})), new LabeledPoint(-1.0, Vectors.dense((double)-1.0, (double[])new double[]{0.0, -0.5}))));
        ChiSqTestResult[] featureTestResults = Statistics.chiSqTest((RDD)obs.rdd());
        int i = 1;
        for (ChiSqTestResult result : featureTestResults) {
            System.out.println("Column " + i + ":");
            System.out.println(result + "\n");
            ++i;
        }
        jsc.stop();
    }
}

