/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasThresholds;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\t\u0013\u0003\u0003i\u0002\"B\u001d\u0001\t\u0003Q\u0004\"B\u001e\u0001\t\u0003a\u0004\"\u0002&\u0001\t\u0003Y\u0005\"B*\u0001\t\u0003\"\u0006\"B0\u0001\t\u0003\u0002\u0007\"\u0002>\u0001\r#Y\bbBA\u0005\u0001\u0011E\u00111\u0002\u0005\b\u0003\u001f\u0001A\u0011KA\t\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!a\f\u0001\t#\t\t\u0004\u0003\u0005\u00028\u0001!\tEEA\u001d\u000f!\t\tE\u0005E\u0001)\u0005\rcaB\t\u0013\u0011\u0003!\u0012Q\t\u0005\u0007s5!\t!a\u0015\t\u000f\u0005US\u0002\"\u0001\u0002X!I\u0011\u0011N\u0007\u0002\u0002\u0013%\u00111\u000e\u0002!!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,GN\u0003\u0002\u0014)\u0005q1\r\\1tg&4\u0017nY1uS>t'BA\u000b\u0017\u0003\tiGN\u0003\u0002\u00181\u0005)1\u000f]1sW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001)2AH\u00133'\r\u0001qD\u000e\t\u0005A\u0005\u001a\u0013'D\u0001\u0013\u0013\t\u0011#CA\nDY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002%K1\u0001A!\u0002\u0014\u0001\u0005\u00049#\u0001\u0004$fCR,(/Z:UsB,\u0017C\u0001\u0015/!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!K\u0018\n\u0005AR#aA!osB\u0011AE\r\u0003\u0006g\u0001\u0011\r\u0001\u000e\u0002\u0002\u001bF\u0011\u0001&\u000e\t\u0005A\u0001\u0019\u0013\u0007\u0005\u0002!o%\u0011\u0001H\u0005\u0002\u001e!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jKJ\u0004\u0016M]1ng\u00061A(\u001b8jiz\"\u0012!N\u0001\u0012g\u0016$\bK]8cC\nLG.\u001b;z\u0007>dGCA\u0019>\u0011\u0015q$\u00011\u0001@\u0003\u00151\u0018\r\\;f!\t\u0001uI\u0004\u0002B\u000bB\u0011!IK\u0007\u0002\u0007*\u0011A\tH\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019S\u0013A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!A\u0012\u0016\u0002\u001bM,G\u000f\u00165sKNDw\u000e\u001c3t)\t\tD\nC\u0003?\u0007\u0001\u0007Q\nE\u0002*\u001dBK!a\u0014\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%\n\u0016B\u0001*+\u0005\u0019!u.\u001e2mK\u0006yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0002V;B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0006if\u0004Xm\u001d\u0006\u00035Z\t1a]9m\u0013\tavK\u0001\u0006TiJ,8\r\u001e+za\u0016DQA\u0018\u0003A\u0002U\u000baa]2iK6\f\u0017!\u0003;sC:\u001chm\u001c:n)\t\t\u0007\u000f\u0005\u0002c[:\u00111m\u001b\b\u0003I*t!!Z5\u000f\u0005\u0019DgB\u0001\"h\u0013\u0005Y\u0012BA\r\u001b\u0013\t9\u0002$\u0003\u0002[-%\u0011A.W\u0001\ba\u0006\u001c7.Y4f\u0013\tqwNA\u0005ECR\fgI]1nK*\u0011A.\u0017\u0005\u0006c\u0016\u0001\rA]\u0001\bI\u0006$\u0018m]3ua\t\u0019\b\u0010E\u0002uk^l\u0011!W\u0005\u0003mf\u0013q\u0001R1uCN,G\u000f\u0005\u0002%q\u0012I\u0011\u0010]A\u0001\u0002\u0003\u0015\ta\n\u0002\u0004?\u0012\n\u0014A\u0006:boJ\u0002(o\u001c2bE&d\u0017\u000e^=J]Bc\u0017mY3\u0015\u0007q\f)\u0001E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fR\ta\u0001\\5oC2<\u0017bAA\u0002}\n1a+Z2u_JDa!a\u0002\u0007\u0001\u0004a\u0018!\u0004:boB\u0013X\rZ5di&|g.A\bsC^\u0014\u0004O]8cC\nLG.\u001b;z)\ra\u0018Q\u0002\u0005\u0007\u0003\u000f9\u0001\u0019\u0001?\u0002\u001dI\fwO\r9sK\u0012L7\r^5p]R\u0019\u0001+a\u0005\t\r\u0005\u001d\u0001\u00021\u0001}\u0003I\u0001(/\u001a3jGR\u0004&o\u001c2bE&d\u0017\u000e^=\u0015\u0007q\fI\u0002\u0003\u0004\u0002\u001c%\u0001\raI\u0001\tM\u0016\fG/\u001e:fg\"*\u0011\"a\b\u0002,A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&Y\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI#a\t\u0003\u000bMKgnY3\"\u0005\u00055\u0012!B\u001a/a9\u0002\u0014A\u00069s_\n\f'-\u001b7jif\u0014\u0004O]3eS\u000e$\u0018n\u001c8\u0015\u0007A\u000b\u0019\u0004\u0003\u0004\u00026)\u0001\r\u0001`\u0001\faJ|'-\u00192jY&$\u00180\u0001\tgS:$7+^7nCJLXj\u001c3fYR\u0011\u00111\b\t\u0007S\u0005uRgP \n\u0007\u0005}\"F\u0001\u0004UkBdWmM\u0001!!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002!\u001bM)Q\"a\u0012\u0002NA\u0019\u0011&!\u0013\n\u0007\u0005-#F\u0001\u0004B]f\u0014VM\u001a\t\u0004S\u0005=\u0013bAA)U\ta1+\u001a:jC2L'0\u00192mKR\u0011\u00111I\u0001 ]>\u0014X.\u00197ju\u0016$v\u000e\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\u0018J\u001c)mC\u000e,G\u0003BA-\u0003?\u00022!KA.\u0013\r\tiF\u000b\u0002\u0005+:LG\u000fC\u0004\u0002b=\u0001\r!a\u0019\u0002\u0003Y\u00042!`A3\u0013\r\t9G \u0002\f\t\u0016t7/\u001a,fGR|'/A\u0006sK\u0006$'+Z:pYZ,GCAA7!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\nA\u0001\\1oO*\u0011\u0011qO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002|\u0005E$AB(cU\u0016\u001cG\u000f")
public abstract class ProbabilisticClassificationModel<FeaturesType, M extends ProbabilisticClassificationModel<FeaturesType, M>>
extends ClassificationModel<FeaturesType, M>
implements ProbabilisticClassifierParams {
    private final DoubleArrayParam thresholds;
    private final Param<String> probabilityCol;

    public static void normalizeToProbabilitiesInPlace(DenseVector denseVector) {
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$ProbabilisticClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double[] getThresholds() {
        return HasThresholds.getThresholds$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public DoubleArrayParam thresholds() {
        return this.thresholds;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThresholds$_setter_$thresholds_$eq(DoubleArrayParam x$1) {
        this.thresholds = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    public M setProbabilityCol(String value) {
        return (M)((ProbabilisticClassificationModel)this.set(this.probabilityCol(), value));
    }

    public M setThresholds(double[] value) {
        Predef$.MODULE$.require(value.length == this.numClasses(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append(this.getClass().getSimpleName()).append(".setThresholds() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(this.numClasses()).append(", but thresholds has length ").append(value.length).toString());
        return (M)((ProbabilisticClassificationModel)this.set(this.thresholds(), value));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.probabilityCol()), this.numClasses());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset outputData;
        block10: {
            StructType outputSchema = this.transformSchema(dataset.schema(), true);
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == this.numClasses(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append(this.getClass().getSimpleName()).append(".transform() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(this.numClasses()).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString());
            }
            outputData = dataset;
            int numColsOutput = 0;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(ProbabilisticClassificationModel $outer) {
                    }
                }
                UserDefinedFunction predictRawUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictRaw(features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                outputData = outputData.withColumn(this.getRawPredictionCol(), predictRawUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.getFeaturesCol())})), outputSchema.apply(this.$(this.rawPredictionCol())).metadata());
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                Column column;
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    JavaUniverse $u2 = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)rawPrediction -> this.raw2probability((Vector)rawPrediction), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
                } else {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    UserDefinedFunction probabilityUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictProbability(features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                    column = probabilityUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
                }
                Column probCol = column;
                outputData = outputData.withColumn(this.$(this.probabilityCol()), probCol, outputSchema.apply(this.$(this.probabilityCol())).metadata());
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                Column column;
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)rawPrediction -> BoxesRunTime.boxToDouble((double)this.raw2prediction(rawPrediction)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
                } else if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)probability -> BoxesRunTime.boxToDouble((double)this.probability2prediction(probability)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))}));
                } else {
                    UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                    column = predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
                }
                Column predCol = column;
                outputData = outputData.withColumn(this.$(this.predictionCol()), predCol, outputSchema.apply(this.$(this.predictionCol())).metadata());
                ++numColsOutput;
            }
            if (numColsOutput != false) break block10;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append(this.uid()).append(": ProbabilisticClassificationModel.transform() does nothing").append(" because no output columns were set.").toString());
        }
        return outputData.toDF();
    }

    public abstract Vector raw2probabilityInPlace(Vector var1);

    public Vector raw2probability(Vector rawPrediction) {
        Vector probs = rawPrediction.copy();
        return this.raw2probabilityInPlace(probs);
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        if (!this.isDefined(this.thresholds())) {
            return rawPrediction.argmax();
        }
        return this.probability2prediction(this.raw2probability(rawPrediction));
    }

    public Vector predictProbability(FeaturesType features) {
        Vector rawPreds = this.predictRaw(features);
        return this.raw2probabilityInPlace(rawPreds);
    }

    public double probability2prediction(Vector probability) {
        if (!this.isDefined(this.thresholds())) {
            return probability.argmax();
        }
        double[] thresholds = this.getThresholds();
        int argMax = 0;
        double max = Double.NEGATIVE_INFINITY;
        int probabilitySize = probability.size();
        for (int i = 0; i < probabilitySize; ++i) {
            double scaled = probability.apply(i) / thresholds[i];
            if (!(scaled > max)) continue;
            max = scaled;
            argMax = i;
        }
        return argMax;
    }

    @Override
    public Tuple3<ProbabilisticClassificationModel<FeaturesType, M>, String, String> findSummaryModel() {
        ProbabilisticClassificationModel model = this.$(this.probabilityCol()).isEmpty() && this.$(this.predictionCol()).isEmpty() ? (ProbabilisticClassificationModel)((PredictionModel)((ProbabilisticClassificationModel)this.copy(ParamMap$.MODULE$.empty())).setProbabilityCol(new StringBuilder(12).append("probability_").append(UUID.randomUUID().toString()).toString())).setPredictionCol(new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString()) : (this.$(this.probabilityCol()).isEmpty() ? ((ProbabilisticClassificationModel)this.copy(ParamMap$.MODULE$.empty())).setProbabilityCol(new StringBuilder(12).append("probability_").append(UUID.randomUUID().toString()).toString()) : (this.$(this.predictionCol()).isEmpty() ? (ProbabilisticClassificationModel)((PredictionModel)this.copy(ParamMap$.MODULE$.empty())).setPredictionCol(new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString()) : this));
        return new Tuple3((Object)model, (Object)model.getProbabilityCol(), (Object)model.getPredictionCol());
    }

    public ProbabilisticClassificationModel() {
        HasProbabilityCol.$init$(this);
        HasThresholds.$init$(this);
        ProbabilisticClassifierParams.$init$(this);
    }
}

