/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseMatrix$;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JValue;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class JsonMatrixConverter$ {
    public static final JsonMatrixConverter$ MODULE$ = new JsonMatrixConverter$();
    private static final String className = "matrix";

    public String className() {
        return className;
    }

    public Matrix fromJson(String json) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JValue jValue = JsonMethods$.MODULE$.parse((Object)json, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
        int n = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "type")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        switch (n) {
            case 0: {
                int numRows = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "numRows")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                int numCols = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "numCols")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                int[] colPtrs = (int[])((IterableOnceOps)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "colPtrs")), (Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Nil$.MODULE$))).toArray((ClassTag)ClassTag$.MODULE$.Int());
                int[] rowIndices = (int[])((IterableOnceOps)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "rowIndices")), (Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Nil$.MODULE$))).toArray((ClassTag)ClassTag$.MODULE$.Int());
                double[] values = (double[])((IterableOnceOps)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "values")), (Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Nil$.MODULE$))).toArray((ClassTag)ClassTag$.MODULE$.Double());
                boolean isTransposed = BoxesRunTime.unboxToBoolean((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "isTransposed")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Boolean()));
                return new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values, isTransposed);
            }
            case 1: {
                int numRows = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "numRows")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                int numCols = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "numCols")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                double[] values = (double[])((IterableOnceOps)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "values")), (Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Nil$.MODULE$))).toArray((ClassTag)ClassTag$.MODULE$.Double());
                boolean isTransposed = BoxesRunTime.unboxToBoolean((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(jValue), "isTransposed")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Boolean()));
                return new DenseMatrix(numRows, numCols, values, isTransposed);
            }
        }
        throw new IllegalArgumentException("Cannot parse " + json + " into a Matrix.");
    }

    public String toJson(Matrix m) {
        DenseMatrix denseMatrix;
        Option option;
        SparseMatrix sparseMatrix;
        Option option2;
        Matrix matrix = m;
        if (matrix instanceof SparseMatrix && !(option2 = SparseMatrix$.MODULE$.unapply(sparseMatrix = (SparseMatrix)matrix)).isEmpty()) {
            int numRows = BoxesRunTime.unboxToInt((Object)((Tuple6)option2.get())._1());
            int numCols = BoxesRunTime.unboxToInt((Object)((Tuple6)option2.get())._2());
            int[] colPtrs = (int[])((Tuple6)option2.get())._3();
            int[] rowIndices = (int[])((Tuple6)option2.get())._4();
            double[] values = (double[])((Tuple6)option2.get())._5();
            boolean isTransposed = BoxesRunTime.unboxToBoolean((Object)((Tuple6)option2.get())._6());
            JObject jValue = JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.className()), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRows"), (Object)BoxesRunTime.boxToInteger((int)numRows)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numCols"), (Object)BoxesRunTime.boxToInteger((int)numCols)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colPtrs"), (Object)ArrayImplicits$.MODULE$.SparkArrayOps((Object)colPtrs).toImmutableArraySeq()), (Function1 & Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowIndices"), (Object)ArrayImplicits$.MODULE$.SparkArrayOps((Object)rowIndices).toImmutableArraySeq()), (Function1 & Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)ArrayImplicits$.MODULE$.SparkArrayOps((Object)values).toImmutableArraySeq()), (Function1 & Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isTransposed"), (Object)BoxesRunTime.boxToBoolean((boolean)isTransposed)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))));
            return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)jValue, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3()));
        }
        if (matrix instanceof DenseMatrix && !(option = DenseMatrix$.MODULE$.unapply(denseMatrix = (DenseMatrix)matrix)).isEmpty()) {
            int numRows = BoxesRunTime.unboxToInt((Object)((Tuple4)option.get())._1());
            int numCols = BoxesRunTime.unboxToInt((Object)((Tuple4)option.get())._2());
            double[] values = (double[])((Tuple4)option.get())._3();
            boolean isTransposed = BoxesRunTime.unboxToBoolean((Object)((Tuple4)option.get())._4());
            JObject jValue = JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.className()), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)1)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRows"), (Object)BoxesRunTime.boxToInteger((int)numRows)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numCols"), (Object)BoxesRunTime.boxToInteger((int)numCols)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)ArrayImplicits$.MODULE$.SparkArrayOps((Object)values).toImmutableArraySeq()), (Function1 & Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isTransposed"), (Object)BoxesRunTime.boxToBoolean((boolean)isTransposed)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))));
            return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)jValue, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3()));
        }
        throw new IllegalArgumentException("Unknown matrix type " + m.getClass() + ".");
    }

    private JsonMatrixConverter$() {
    }
}

