/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.examples.SparkLR;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class SparkLR$ {
    public static final SparkLR$ MODULE$ = new SparkLR$();
    private static final int N = 10000;
    private static final int D = 10;
    private static final double R = 0.7;
    private static final int ITERATIONS = 5;
    private static final Random rand = new Random(42L);

    public int N() {
        return N;
    }

    public int D() {
        return D;
    }

    public double R() {
        return R;
    }

    public int ITERATIONS() {
        return ITERATIONS;
    }

    public Random rand() {
        return rand;
    }

    public Seq<SparkLR.DataPoint> generateData() {
        return ArraySeq$.MODULE$.unsafeWrapArray(Array$.MODULE$.tabulate(this.N(), (Function1 & Serializable)i -> this.generatePoint$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(SparkLR.DataPoint.class)));
    }

    public void showWarning() {
        System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of Logistic Regression and is given as an example!\n        |Please use org.apache.spark.ml.classification.LogisticRegression\n        |for more conventional use.\n      ")));
    }

    public void main(String[] args) {
        this.showWarning();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkLR").getOrCreate();
        int numSlices = args.length > 0 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[0])) : 2;
        RDD points = spark.sparkContext().parallelize(this.generateData(), numSlices, ClassTag$.MODULE$.apply(SparkLR.DataPoint.class)).cache();
        DenseVector w = DenseVector$.MODULE$.fill$mDc$sp(this.D(), (Function0)(JFunction0.mcD.sp & Serializable)() -> (double)2 * MODULE$.rand().nextDouble() - 1.0, (ClassTag)ClassTag$.MODULE$.Double());
        Predef$.MODULE$.println((Object)("Initial w: " + w));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach((Function1 & Serializable)i -> SparkLR$.$anonfun$main$2(points, w, BoxesRunTime.unboxToInt((Object)i)));
        Predef$.MODULE$.println((Object)("Final w: " + w));
        spark.stop();
    }

    private final SparkLR.DataPoint generatePoint$1(int i) {
        int y = i % 2 == 0 ? -1 : 1;
        DenseVector x = DenseVector$.MODULE$.fill$mDc$sp(this.D(), (Function0)(JFunction0.mcD.sp & Serializable)() -> MODULE$.rand().nextGaussian() + (double)y * MODULE$.R(), (ClassTag)ClassTag$.MODULE$.Double());
        return new SparkLR.DataPoint((Vector<Object>)x, y);
    }

    public static final /* synthetic */ DenseVector $anonfun$main$2(RDD points$1, DenseVector w$1, int i) {
        Predef$.MODULE$.println((Object)("On iteration " + i));
        Vector gradient = (Vector)points$1.map((Function1 & Serializable)p -> (Vector)((ImmutableNumericOps)p.x().$times((Object)BoxesRunTime.boxToDouble((double)(1.0 / (1.0 + package$.MODULE$.exp(-p.y() * BoxesRunTime.unboxToDouble((Object)w$1.dot(p.x(), HasOps$.MODULE$.impl_OpMulInner_DV_V_eq_S_Double())))) - 1.0)), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix())).$times((Object)BoxesRunTime.boxToDouble((double)p.y()), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix()), ClassTag$.MODULE$.apply(Vector.class)).reduce((Function2 & Serializable)(x$1, x$2) -> (Vector)x$1.$plus(x$2, (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpAdd()));
        return (DenseVector)w$1.$minus$eq((Object)gradient, (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_DV_V_zero_idempotent_Double_OpSub());
    }

    private SparkLR$() {
    }
}

