/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.sql.SparkSQLExample;
import org.apache.spark.examples.sql.SparkSQLExample$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class SparkSQLExample$ {
    public static final SparkSQLExample$ MODULE$ = new SparkSQLExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Spark SQL basic example").config("spark.some.config.option", "some-value").getOrCreate();
        this.runBasicDataFrameExample(spark);
        this.runDatasetCreationExample(spark);
        this.runInferSchemaExample(spark);
        this.runProgrammaticSchemaExample(spark);
        spark.stop();
    }

    private void runBasicDataFrameExample(SparkSession spark) {
        Dataset df = spark.read().json("examples/src/main/resources/people.json");
        df.show();
        df.printSchema();
        df.select("name", (Seq)Nil$.MODULE$).show();
        df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"age"}))).$((Seq)Nil$.MODULE$).$plus((Object)BoxesRunTime.boxToInteger((int)1))})).show();
        df.filter(spark.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"age"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)21))).show();
        df.groupBy("age", (Seq)Nil$.MODULE$).count().show();
        df.createOrReplaceTempView("people");
        Dataset sqlDF = spark.sql("SELECT * FROM people");
        sqlDF.show();
        df.createGlobalTempView("people");
        spark.sql("SELECT * FROM global_temp.people").show();
        spark.newSession().sql("SELECT * FROM global_temp.people").show();
    }

    private void runDatasetCreationExample(SparkSession spark) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SparkSQLExample$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.SparkSQLExample.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_SparkSQLExample$$typecreator10$1() {
            }
        }
        Dataset caseClassDS = spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new SparkSQLExample.Person("Andy", 32L), (List)Nil$.MODULE$), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_SparkSQLExample$$typecreator10$1()))).toDS();
        caseClassDS.show();
        Dataset primitiveDS = spark.implicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), spark.implicits().newIntEncoder()).toDS();
        primitiveDS.map((Function1)(JFunction1.mcII.sp & Serializable)x$1 -> x$1 + 1, spark.implicits().newIntEncoder()).collect();
        String path = "examples/src/main/resources/people.json";
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SparkSQLExample$$typecreator15$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.SparkSQLExample.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_SparkSQLExample$$typecreator15$1() {
            }
        }
        Dataset peopleDS = spark.read().json(path).as(spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_sql_SparkSQLExample$$typecreator15$1())));
        peopleDS.show();
    }

    private void runInferSchemaExample(SparkSession spark) {
        SparkContext qual$1 = spark.sparkContext();
        String x$1 = "examples/src/main/resources/people.txt";
        int x$22 = qual$1.textFile$default$2();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SparkSQLExample$$typecreator10$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.SparkSQLExample.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_SparkSQLExample$$typecreator10$2() {
            }
        }
        Dataset peopleDF = spark.implicits().rddToDatasetHolder(qual$1.textFile("examples/src/main/resources/people.txt", x$22).map((Function1 & Serializable)x$2 -> x$2.split(","), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1 & Serializable)attributes -> new SparkSQLExample.Person(attributes[0], StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(attributes[1].trim()))), ClassTag$.MODULE$.apply(SparkSQLExample.Person.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_SparkSQLExample$$typecreator10$2()))).toDF();
        peopleDF.createOrReplaceTempView("people");
        Dataset teenagersDF = spark.sql("SELECT name, age FROM people WHERE age BETWEEN 13 AND 19");
        teenagersDF.map((Function1 & Serializable)teenager -> "Name: " + teenager.apply(0), spark.implicits().newStringEncoder()).show();
        teenagersDF.map((Function1 & Serializable)teenager -> "Name: " + teenager.getAs("name"), spark.implicits().newStringEncoder()).show();
        Encoder mapEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Map.class));
        teenagersDF.map((Function1 & Serializable)teenager -> teenager.getValuesMap((Seq)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"age", (List)Nil$.MODULE$))), mapEncoder).collect();
    }

    private void runProgrammaticSchemaExample(SparkSession spark) {
        SparkContext qual$1 = spark.sparkContext();
        String x$1 = "examples/src/main/resources/people.txt";
        int x$2 = qual$1.textFile$default$2();
        RDD peopleRDD = qual$1.textFile("examples/src/main/resources/people.txt", x$2);
        String schemaString = "name age";
        StructField[] fields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schemaString.split(" ")), (Function1 & Serializable)fieldName -> new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), ClassTag$.MODULE$.apply(StructField.class));
        StructType schema = new StructType(fields);
        RDD rowRDD = peopleRDD.map((Function1 & Serializable)x$3 -> x$3.split(","), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1 & Serializable)attributes -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{attributes[0], attributes[1].trim()})), ClassTag$.MODULE$.apply(Row.class));
        Dataset peopleDF = spark.createDataFrame(rowRDD, schema);
        peopleDF.createOrReplaceTempView("people");
        Dataset results = spark.sql("SELECT name FROM people");
        results.map((Function1 & Serializable)attributes -> "Name: " + attributes.apply(0), spark.implicits().newStringEncoder()).show();
    }

    private SparkSQLExample$() {
    }
}

