/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.utils;

import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public final class TimeUtils {
    static final long HUNDRED_NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L) / 100L;

    public static boolean isUnixTime(FileTime time) {
        return TimeUtils.isUnixTime(TimeUtils.toUnixTime(time));
    }

    public static boolean isUnixTime(long seconds) {
        return Integer.MIN_VALUE <= seconds && seconds <= Integer.MAX_VALUE;
    }

    public static long toUnixTime(FileTime fileTime) {
        return fileTime != null ? fileTime.to(TimeUnit.SECONDS) : 0L;
    }

    public static FileTime unixTimeToFileTime(long time) {
        return FileTime.from(time, TimeUnit.SECONDS);
    }
}

