/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.pythonconverters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.SparkException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class AvroConversionUtil$
implements Serializable {
    public static final AvroConversionUtil$ MODULE$ = new AvroConversionUtil$();

    public Object fromAvro(Object obj, Schema schema) {
        if (obj == null) {
            return null;
        }
        Schema.Type type = schema.getType();
        if (Schema.Type.UNION.equals(type)) {
            return this.unpackUnion(obj, schema);
        }
        if (Schema.Type.ARRAY.equals(type)) {
            return this.unpackArray(obj, schema);
        }
        if (Schema.Type.FIXED.equals(type)) {
            return this.unpackFixed(obj, schema);
        }
        if (Schema.Type.MAP.equals(type)) {
            return this.unpackMap(obj, schema);
        }
        if (Schema.Type.BYTES.equals(type)) {
            return this.unpackBytes(obj);
        }
        if (Schema.Type.RECORD.equals(type)) {
            return this.unpackRecord(obj);
        }
        if (Schema.Type.STRING.equals(type)) {
            return obj.toString();
        }
        if (Schema.Type.ENUM.equals(type)) {
            return obj.toString();
        }
        if (Schema.Type.NULL.equals(type)) {
            return obj;
        }
        if (Schema.Type.BOOLEAN.equals(type)) {
            return obj;
        }
        if (Schema.Type.DOUBLE.equals(type)) {
            return obj;
        }
        if (Schema.Type.FLOAT.equals(type)) {
            return obj;
        }
        if (Schema.Type.INT.equals(type)) {
            return obj;
        }
        if (Schema.Type.LONG.equals(type)) {
            return obj;
        }
        throw new SparkException("Unknown Avro schema type " + type.getName());
    }

    public java.util.Map<String, Object> unpackRecord(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object object = obj;
        if (!(object instanceof IndexedRecord)) {
            throw new SparkException("Unsupported RECORD type " + object.getClass().getName());
        }
        IndexedRecord indexedRecord = (IndexedRecord)object;
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(indexedRecord.getSchema().getFields()).asScala().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Schema.Field f = (Schema.Field)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return map.put(f.name(), MODULE$.fromAvro(indexedRecord.get(i), f.schema()));
            }
            throw new MatchError((Object)tuple2);
        });
        return map;
    }

    public java.util.Map<String, Object> unpackMap(Object obj, Schema schema) {
        return CollectionConverters$.MODULE$.MutableMapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)obj).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                return new Tuple2((Object)key.toString(), MODULE$.fromAvro(value, schema.getValueType()));
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public byte[] unpackFixed(Object obj, Schema schema) {
        return this.unpackBytes(((GenericFixed)obj).bytes());
    }

    public byte[] unpackBytes(Object obj) {
        byte[] byArray;
        Object object = obj;
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] arr = new byte[byteBuffer.remaining()];
            byteBuffer.get(arr);
            byArray = arr;
        } else if (object instanceof byte[]) {
            byte[] byArray2;
            byArray = byArray2 = (byte[])object;
        } else {
            throw new SparkException("Unknown BYTES type " + object.getClass().getName());
        }
        byte[] bytes = byArray;
        byte[] bytearray = new byte[bytes.length];
        System.arraycopy(bytes, 0, bytearray, 0, bytes.length);
        return bytearray;
    }

    public Collection<Object> unpackArray(Object obj, Schema schema) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(collection).asScala().map((Function1 & Serializable)x$1 -> MODULE$.fromAvro(x$1, schema.getElementType()))).toSeq()).asJava();
        }
        if (ScalaRunTime$.MODULE$.isArray(object2, 1) && (object = object2).getClass().getComponentType().isPrimitive()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(object))).asJava();
        }
        if (ScalaRunTime$.MODULE$.isArray(object2, 1)) {
            Object object3 = object2;
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(object3), (Function1 & Serializable)x$2 -> MODULE$.fromAvro(x$2, schema.getElementType()), ClassTag$.MODULE$.Any())))).asJava();
        }
        throw new SparkException("Unknown ARRAY type " + object2.getClass().getName());
    }

    public Object unpackUnion(Object obj, Schema schema) {
        SeqOps seqOps;
        SeqOps seqOps2;
        SeqOps seqOps3;
        List list = CollectionConverters$.MODULE$.ListHasAsScala(schema.getTypes()).asScala().toList();
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0) {
            Schema s = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
            return this.fromAvro(obj, s);
        }
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
            Schema n = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Schema s = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            Schema.Type type = n.getType();
            Schema.Type type2 = Schema.Type.NULL;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                return this.fromAvro(obj, s);
            }
        }
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Schema s = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Schema n = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Schema.Type type = n.getType();
            Schema.Type type3 = Schema.Type.NULL;
            if (!(type != null ? !type.equals(type3) : type3 != null)) {
                return this.fromAvro(obj, s);
            }
        }
        throw new SparkException("Unions may only consist of a concrete type and null");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AvroConversionUtil$.class);
    }

    private AvroConversionUtil$() {
    }
}

