/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.ValidateSubqueryExpression$;
import org.apache.spark.sql.catalyst.analysis.resolver.AutoGeneratedAliasProvider;
import org.apache.spark.sql.catalyst.analysis.resolver.CoercesExpressionTypes;
import org.apache.spark.sql.catalyst.analysis.resolver.CteRegistry;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionIdAssigner;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversal;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversalStack;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvedSubqueryExpressionPlan;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.SubqueryRegistry;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.InSubquery;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.SubExprUtils$;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\f\u0018\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t1\u0001\u0011\t\u0011)A\u0005k!)\u0001\b\u0001C\u0001s!9Q\b\u0001b\u0001\n\u0013q\u0004B\u0002\"\u0001A\u0003%q\bC\u0004D\u0001\t\u0007I\u0011\u0002#\t\r!\u0003\u0001\u0015!\u0003F\u0011\u001dI\u0005A1A\u0005\n)CaA\u0014\u0001!\u0002\u0013Y\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B)\t\u000fU\u0003!\u0019!C\u0005-\"1!\f\u0001Q\u0001\n]Cqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004a\u0001\u0001\u0006I!\u0018\u0005\u0006C\u0002!\tA\u0019\u0005\u0006]\u0002!\ta\u001c\u0005\u0006k\u0002!\tA\u001e\u0005\u0006y\u0002!\t! \u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\u0011!dU;ccV,'/_#yaJ,7o]5p]J+7o\u001c7wKJT!\u0001G\r\u0002\u0011I,7o\u001c7wKJT!AG\u000e\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001H\u000f\u0002\u0011\r\fG/\u00197zgRT!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011afL\u0007\u0002/%\u0011\u0001g\u0006\u0002\u0017\u0007>,'oY3t\u000bb\u0004(/Z:tS>tG+\u001f9fg\u0006\u0011R\r\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s!\tq3'\u0003\u00025/\t\u0011R\t\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s!\tqc'\u0003\u00028/\tA!+Z:pYZ,'/\u0001\u0004=S:LGO\u0010\u000b\u0004umb\u0004C\u0001\u0018\u0001\u0011\u0015\t4\u00011\u00013\u0011\u0015A2\u00011\u00016\u0003\u0019\u00198m\u001c9fgV\tq\b\u0005\u0002/\u0001&\u0011\u0011i\u0006\u0002\u000f\u001d\u0006lWmU2pa\u0016\u001cF/Y2l\u0003\u001d\u00198m\u001c9fg\u0002\n!\u0002\u001e:bm\u0016\u00148/\u00197t+\u0005)\u0005C\u0001\u0018G\u0013\t9uC\u0001\u000fFqB\u0014Xm]:j_:$&/Z3Ue\u00064XM]:bYN#\u0018mY6\u0002\u0017Q\u0014\u0018M^3sg\u0006d7\u000fI\u0001\fGR,'+Z4jgR\u0014\u00180F\u0001L!\tqC*\u0003\u0002N/\tY1\t^3SK\u001eL7\u000f\u001e:z\u00031\u0019G/\u001a*fO&\u001cHO]=!\u0003A\u0019XOY9vKJL(+Z4jgR\u0014\u00180F\u0001R!\tq#+\u0003\u0002T/\t\u00012+\u001e2rk\u0016\u0014\u0018PU3hSN$(/_\u0001\u0012gV\u0014\u0017/^3ssJ+w-[:uef\u0004\u0013\u0001F3yaJ,7o]5p]&#\u0017i]:jO:,'/F\u0001X!\tq\u0003,\u0003\u0002Z/\t!R\t\u001f9sKN\u001c\u0018n\u001c8JI\u0006\u001b8/[4oKJ\fQ#\u001a=qe\u0016\u001c8/[8o\u0013\u0012\f5o]5h]\u0016\u0014\b%\u0001\u000ebkR|w)\u001a8fe\u0006$X\rZ!mS\u0006\u001c\bK]8wS\u0012,'/F\u0001^!\tqc,\u0003\u0002`/\tQ\u0012)\u001e;p\u000f\u0016tWM]1uK\u0012\fE.[1t!J|g/\u001b3fe\u0006Y\u0012-\u001e;p\u000f\u0016tWM]1uK\u0012\fE.[1t!J|g/\u001b3fe\u0002\nQC]3t_24XmU2bY\u0006\u00148+\u001e2rk\u0016\u0014\u0018\u0010\u0006\u0002dSB\u0011AmZ\u0007\u0002K*\u0011amG\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002iK\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b)\u0004\u0002\u0019A6\u00021Ut'/Z:pYZ,GmU2bY\u0006\u00148+\u001e2rk\u0016\u0014\u0018\u0010\u0005\u0002eY&\u0011Q.\u001a\u0002\u000f'\u000e\fG.\u0019:Tk\n\fX/\u001a:z\u0003E\u0011Xm]8mm\u0016LenU;ccV,'/\u001f\u000b\u0003GBDQ!]\tA\u0002I\fA#\u001e8sKN|GN^3e\u0013:\u001cVOY9vKJL\bC\u00013t\u0013\t!XM\u0001\u0006J]N+(-];fef\f\u0001C]3t_24X\rT5tiF+XM]=\u0015\u0005\r<\b\"\u0002=\u0013\u0001\u0004I\u0018aE;oe\u0016\u001cx\u000e\u001c<fI2K7\u000f^)vKJL\bC\u00013{\u0013\tYXMA\u0005MSN$\u0018+^3ss\u0006i!/Z:pYZ,W\t_5tiN$\"a\u0019@\t\r}\u001c\u0002\u0019AA\u0001\u0003A)hN]3t_24X\rZ#ySN$8\u000fE\u0002e\u0003\u0007I1!!\u0002f\u0005\u0019)\u00050[:ug\u0006i\"/Z:pYZ,7+\u001e2rk\u0016\u0014\u00180\u0012=qe\u0016\u001c8/[8o!2\fg\u000e\u0006\u0003\u0002\f\u0005E\u0001c\u0001\u0018\u0002\u000e%\u0019\u0011qB\f\u0003=I+7o\u001c7wK\u0012\u001cVOY9vKJLX\t\u001f9sKN\u001c\u0018n\u001c8QY\u0006t\u0007bBA\n)\u0001\u0007\u0011QC\u0001\u0017k:\u0014Xm]8mm\u0016$7+\u001e2rk\u0016\u0014\u0018\u0010\u00157b]B!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0004\u0003?Y\u0012!\u00029mC:\u001c\u0018\u0002BA\u0012\u00033\u00111\u0002T8hS\u000e\fG\u000e\u00157b]\u0006Qb/\u00197jI\u0006$XmU;ccV,'/_#yaJ,7o]5p]R!\u0011\u0011FA\u0018!\rA\u00131F\u0005\u0004\u0003[I#\u0001B+oSRDq!!\r\u0016\u0001\u0004\t\u0019$\u0001\ntk\n\fX/\u001a:z\u000bb\u0004(/Z:tS>t\u0007c\u00013\u00026%\u0019\u0011qG3\u0003%M+(-];fef,\u0005\u0010\u001d:fgNLwN\u001c")
public class SubqueryExpressionResolver
implements CoercesExpressionTypes {
    private final ExpressionResolver expressionResolver;
    private final Resolver resolver;
    private final NameScopeStack scopes;
    private final ExpressionTreeTraversalStack traversals;
    private final CteRegistry cteRegistry;
    private final SubqueryRegistry subqueryRegistry;
    private final ExpressionIdAssigner expressionIdAssigner;
    private final AutoGeneratedAliasProvider autoGeneratedAliasProvider;
    private Seq<Function1<Expression, Expression>> ansiTransformations;
    private Seq<Function1<Expression, Expression>> nonAnsiTransformations;

    @Override
    public Expression coerceExpressionTypes(Expression expression, ExpressionTreeTraversal expressionTreeTraversal) {
        return CoercesExpressionTypes.coerceExpressionTypes$(this, expression, expressionTreeTraversal);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public Seq<Function1<Expression, Expression>> ansiTransformations() {
        return this.ansiTransformations;
    }

    @Override
    public Seq<Function1<Expression, Expression>> nonAnsiTransformations() {
        return this.nonAnsiTransformations;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$ansiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.ansiTransformations = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$nonAnsiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.nonAnsiTransformations = x$1;
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    private ExpressionTreeTraversalStack traversals() {
        return this.traversals;
    }

    private CteRegistry cteRegistry() {
        return this.cteRegistry;
    }

    private SubqueryRegistry subqueryRegistry() {
        return this.subqueryRegistry;
    }

    private ExpressionIdAssigner expressionIdAssigner() {
        return this.expressionIdAssigner;
    }

    private AutoGeneratedAliasProvider autoGeneratedAliasProvider() {
        return this.autoGeneratedAliasProvider;
    }

    public Expression resolveScalarSubquery(ScalarSubquery unresolvedScalarSubquery) {
        LogicalPlan logicalPlan = this.traversals().current().parentOperator();
        if (logicalPlan instanceof UnresolvedInlineTable) {
            UnresolvedInlineTable unresolvedInlineTable = (UnresolvedInlineTable)logicalPlan;
            throw QueryCompilationErrors$.MODULE$.inlineTableContainsScalarSubquery(unresolvedInlineTable);
        }
        ResolvedSubqueryExpressionPlan resolvedSubqueryExpressionPlan = this.resolveSubqueryExpressionPlan(unresolvedScalarSubquery.plan());
        ScalarSubquery resolvedScalarSubquery = unresolvedScalarSubquery.copy(resolvedSubqueryExpressionPlan.plan(), resolvedSubqueryExpressionPlan.outerExpressions(), unresolvedScalarSubquery.copy$default$3(), unresolvedScalarSubquery.copy$default$4(), unresolvedScalarSubquery.copy$default$5(), unresolvedScalarSubquery.copy$default$6(), unresolvedScalarSubquery.copy$default$7());
        ScalarSubquery coercedScalarSubquery = (ScalarSubquery)this.coerceExpressionTypes(resolvedScalarSubquery, this.traversals().current());
        this.validateSubqueryExpression(coercedScalarSubquery);
        return coercedScalarSubquery;
    }

    public Expression resolveInSubquery(InSubquery unresolvedInSubquery) {
        ListQuery resolvedQuery = (ListQuery)this.expressionResolver.resolve(unresolvedInSubquery.query());
        Seq resolvedValues = (Seq)unresolvedInSubquery.values().map((Function1 & Serializable)value -> $this.expressionResolver.resolve((Expression)value));
        InSubquery resolvedInSubquery = unresolvedInSubquery.copy((Seq<Expression>)resolvedValues, resolvedQuery);
        InSubquery coercedInSubquery = (InSubquery)this.coerceExpressionTypes(resolvedInSubquery, this.traversals().current());
        this.validateSubqueryExpression(coercedInSubquery.query());
        return coercedInSubquery;
    }

    public Expression resolveListQuery(ListQuery unresolvedListQuery) {
        ResolvedSubqueryExpressionPlan resolvedSubqueryExpressionPlan = this.resolveSubqueryExpressionPlan(unresolvedListQuery.plan());
        LogicalPlan x$1 = resolvedSubqueryExpressionPlan.plan();
        Seq<Expression> x$2 = resolvedSubqueryExpressionPlan.outerExpressions();
        int x$3 = resolvedSubqueryExpressionPlan.output().size();
        ExprId x$4 = unresolvedListQuery.copy$default$3();
        Seq<Expression> x$5 = unresolvedListQuery.copy$default$5();
        Option<HintInfo> x$6 = unresolvedListQuery.copy$default$6();
        return unresolvedListQuery.copy(x$1, x$2, x$4, x$3, x$5, x$6);
    }

    public Expression resolveExists(Exists unresolvedExists) {
        ResolvedSubqueryExpressionPlan resolvedSubqueryExpressionPlan = this.resolveSubqueryExpressionPlan(unresolvedExists.plan());
        Exists resolvedExists = unresolvedExists.copy(resolvedSubqueryExpressionPlan.plan(), resolvedSubqueryExpressionPlan.outerExpressions(), unresolvedExists.copy$default$3(), unresolvedExists.copy$default$4(), unresolvedExists.copy$default$5());
        Exists coercedExists = (Exists)this.coerceExpressionTypes(resolvedExists, this.traversals().current());
        this.validateSubqueryExpression(coercedExists);
        return coercedExists;
    }

    private ResolvedSubqueryExpressionPlan resolveSubqueryExpressionPlan(LogicalPlan unresolvedSubqueryPlan) {
        ResolvedSubqueryExpressionPlan resolvedSubqueryExpressionPlan;
        this.expressionIdAssigner().pushMapping(true);
        this.scopes().pushScope(true);
        this.cteRegistry().pushScope(true, this.cteRegistry().pushScope$default$2());
        this.subqueryRegistry().pushScope(this.traversals().current().parentOperator(), this.autoGeneratedAliasProvider());
        try {
            LogicalPlan resolvedPlan = this.resolver.resolve(unresolvedSubqueryPlan);
            resolvedSubqueryExpressionPlan = new ResolvedSubqueryExpressionPlan(resolvedPlan, this.scopes().current().output(), SubExprUtils$.MODULE$.getOuterReferences(resolvedPlan));
        }
        finally {
            this.subqueryRegistry().popScope();
            this.cteRegistry().popScope();
            this.scopes().popScope();
            this.expressionIdAssigner().popMapping(this.expressionIdAssigner().popMapping$default$1());
        }
        ResolvedSubqueryExpressionPlan resolvedSubqueryExpressionPlan2 = resolvedSubqueryExpressionPlan;
        resolvedSubqueryExpressionPlan2.outerExpressions().foreach((Function1 & Serializable)expression -> {
            this.expressionResolver.validateExpressionUnderSupportedOperator(expression);
            return BoxedUnit.UNIT;
        });
        return resolvedSubqueryExpressionPlan2;
    }

    private void validateSubqueryExpression(SubqueryExpression subqueryExpression) {
        ValidateSubqueryExpression$.MODULE$.apply(this.traversals().current().parentOperator(), subqueryExpression, true);
    }

    public SubqueryExpressionResolver(ExpressionResolver expressionResolver, Resolver resolver) {
        this.expressionResolver = expressionResolver;
        this.resolver = resolver;
        SQLConfHelper.$init$(this);
        CoercesExpressionTypes.$init$(this);
        this.scopes = resolver.getNameScopes();
        this.traversals = expressionResolver.getExpressionTreeTraversals();
        this.cteRegistry = resolver.getCteRegistry();
        this.subqueryRegistry = resolver.getSubqueryRegistry();
        this.expressionIdAssigner = expressionResolver.getExpressionIdAssigner();
        this.autoGeneratedAliasProvider = new AutoGeneratedAliasProvider(expressionResolver.getExpressionIdAssigner());
        Statics.releaseFence();
    }
}

