/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import net.razorvine.pickle.Pickler;
import org.apache.spark.api.python.PythonFunction;
import org.apache.spark.api.python.PythonWorkerUtils$;
import org.apache.spark.api.python.SpecialLengths$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.python.PythonDataSourceCreationResult;
import org.apache.spark.sql.execution.python.PythonPlannerRunner;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\u0006\f\tqA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u001d9\u0006A1A\u0005BaCa\u0001\u0019\u0001!\u0002\u0013I\u0006\"B1\u0001\t#\u0012\u0007\"\u0002>\u0001\t#Z(!I+tKJ$UMZ5oK\u0012\u0004\u0016\u0010\u001e5p]\u0012\u000bG/Y*pkJ\u001cWMU;o]\u0016\u0014(B\u0001\u0007\u000e\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u0011abD\u0001\u0003mJR!\u0001E\t\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003%M\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Q)\u0012aA:rY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0002c\u0001\u0010!E5\tqD\u0003\u0002\r#%\u0011\u0011e\b\u0002\u0014!f$\bn\u001c8QY\u0006tg.\u001a:Sk:tWM\u001d\t\u0003G\u0011j\u0011aC\u0005\u0003K-\u0011a\u0004U=uQ>tG)\u0019;b'>,(oY3De\u0016\fG/[8o%\u0016\u001cX\u000f\u001c;\u0002\u001b\u0011\fG/Y*pkJ\u001cWm\u00117t!\tAC&D\u0001*\u0015\ta!F\u0003\u0002,+\u0005\u0019\u0011\r]5\n\u00055J#A\u0004)zi\"|gNR;oGRLwN\\\u0001\taJ|g/\u001b3feB\u0011\u0001'\u000f\b\u0003c]\u0002\"AM\u001b\u000e\u0003MR!\u0001N\u000e\u0002\rq\u0012xn\u001c;?\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a*\u0014aE;tKJ\u001c\u0006/Z2jM&,GmU2iK6\f\u0007c\u0001 @\u00036\tQ'\u0003\u0002Ak\t1q\n\u001d;j_:\u0004\"AQ#\u000e\u0003\rS!\u0001R\n\u0002\u000bQL\b/Z:\n\u0005\u0019\u001b%AC*ueV\u001cG\u000fV=qK\u00069q\u000e\u001d;j_:\u001c\bcA%O_5\t!J\u0003\u0002L\u0019\u0006!Q\u000f^5m\u0015\ti5#\u0001\u0005dCR\fG._:u\u0013\ty%J\u0001\nDCN,\u0017J\\:f]NLG/\u001b<f\u001b\u0006\u0004\u0018A\u0002\u001fj]&$h\bF\u0003S'R+f\u000b\u0005\u0002$\u0001!)a%\u0002a\u0001O!)a&\u0002a\u0001_!)A(\u0002a\u0001{!)q)\u0002a\u0001\u0011\u0006aqo\u001c:lKJlu\u000eZ;mKV\t\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u0006!A.\u00198h\u0015\u0005q\u0016\u0001\u00026bm\u0006L!AO.\u0002\u001b]|'o[3s\u001b>$W\u000f\\3!\u000359(/\u001b;f)>\u0004\u0016\u0010\u001e5p]R\u00191M\u001a8\u0011\u0005y\"\u0017BA36\u0005\u0011)f.\u001b;\t\u000b\u001dD\u0001\u0019\u00015\u0002\u000f\u0011\fG/Y(viB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.X\u0001\u0003S>L!!\u001c6\u0003!\u0011\u000bG/Y(viB,Ho\u0015;sK\u0006l\u0007\"B8\t\u0001\u0004\u0001\u0018a\u00029jG.dWM\u001d\t\u0003cbl\u0011A\u001d\u0006\u0003gR\fa\u0001]5dW2,'BA;w\u0003%\u0011\u0018M_8sm&tWMC\u0001x\u0003\rqW\r^\u0005\u0003sJ\u0014q\u0001U5dW2,'/A\tsK\u000e,\u0017N^3Ge>l\u0007+\u001f;i_:$\"A\t?\t\u000buL\u0001\u0019\u0001@\u0002\r\u0011\fG/Y%o!\tIw0C\u0002\u0002\u0002)\u0014q\u0002R1uC&s\u0007/\u001e;TiJ,\u0017-\u001c")
public class UserDefinedPythonDataSourceRunner
extends PythonPlannerRunner<PythonDataSourceCreationResult> {
    private final PythonFunction dataSourceCls;
    private final String provider;
    private final Option<StructType> userSpecifiedSchema;
    private final CaseInsensitiveMap<String> options;
    private final String workerModule;

    @Override
    public String workerModule() {
        return this.workerModule;
    }

    @Override
    public void writeToPython(DataOutputStream dataOut, Pickler pickler) {
        PythonWorkerUtils$.MODULE$.writePythonFunction(this.dataSourceCls, dataOut);
        PythonWorkerUtils$.MODULE$.writeUTF(this.provider, dataOut);
        dataOut.writeBoolean(this.userSpecifiedSchema.isDefined());
        this.userSpecifiedSchema.map((Function1 & Serializable)x$2 -> x$2.json()).foreach((Function1 & Serializable)x$3 -> {
            PythonWorkerUtils$.MODULE$.writeUTF(x$3, dataOut);
            return BoxedUnit.UNIT;
        });
        dataOut.writeInt(this.options.size());
        this.options.iterator().foreach((Function1 & Serializable)x0$1 -> {
            UserDefinedPythonDataSourceRunner.$anonfun$writeToPython$3(dataOut, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public PythonDataSourceCreationResult receiveFromPython(DataInputStream dataIn) {
        DataType schema;
        int length = dataIn.readInt();
        if (length == SpecialLengths$.MODULE$.PYTHON_EXCEPTION_THROWN()) {
            String msg = PythonWorkerUtils$.MODULE$.readUTF(dataIn);
            throw QueryCompilationErrors$.MODULE$.pythonDataSourceError("create", "instance", msg);
        }
        byte[] pickledDataSourceInstance = PythonWorkerUtils$.MODULE$.readBytes(length, dataIn);
        int isDDLString = dataIn.readInt();
        String schemaStr = PythonWorkerUtils$.MODULE$.readUTF(dataIn);
        DataType dataType = schema = isDDLString == 1 ? DataType$.MODULE$.fromDDL(schemaStr) : DataType$.MODULE$.fromJson(schemaStr);
        if (!(schema instanceof StructType)) {
            throw QueryCompilationErrors$.MODULE$.schemaIsNotStructTypeError(schemaStr, schema);
        }
        return new PythonDataSourceCreationResult(pickledDataSourceInstance, (StructType)schema);
    }

    public static final /* synthetic */ void $anonfun$writeToPython$3(DataOutputStream dataOut$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            PythonWorkerUtils$.MODULE$.writeUTF(key, dataOut$1);
            PythonWorkerUtils$.MODULE$.writeUTF(value, dataOut$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public UserDefinedPythonDataSourceRunner(PythonFunction dataSourceCls, String provider, Option<StructType> userSpecifiedSchema, CaseInsensitiveMap<String> options) {
        this.dataSourceCls = dataSourceCls;
        this.provider = provider;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.options = options;
        super(dataSourceCls);
        this.workerModule = "pyspark.sql.worker.create_data_source";
    }
}

