/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TryToTimeExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(str[, format]) - Parses the `str` expression with the `format` expression to a time.\n    If `format` is malformed or its application does not result in a well formed time, the function\n    returns NULL. By default, it follows casting rules to a time if the `format` is omitted.\n  ", arguments="\n    Arguments:\n      * str - A string to be parsed to time.\n      * format - Time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n                 time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('00:12:00.001');\n       00:12:00.001\n      > SELECT _FUNC_('12.10.05.999999', 'HH.mm.ss.SSSSSS');\n       12:10:05.999999\n      > SELECT _FUNC_('foo', 'HH:mm:ss');\n       NULL\n  ", group="datetime_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\n!\u0004\u0016:z)>$\u0016.\\3FqB\u0014Xm]:j_:\u0014U/\u001b7eKJT!AB\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0011%\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001\u0001\t\u0003'\u0005i\u0011!\u0002\u0002\u001b)JLHk\u001c+j[\u0016,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\n\u0004\u0003Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eA5\taD\u0003\u0002 \u000f\u0005A\u0011M\\1msNL7/\u0003\u0002\"=\t\tR\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002\rqJg.\u001b;?)\u0005\u0011\u0012!\u00022vS2$Gc\u0001\u0014*mA\u00111cJ\u0005\u0003Q\u0015\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015Q3\u00011\u0001,\u0003!1WO\\2OC6,\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/15\tqF\u0003\u00021#\u00051AH]8pizJ!A\r\r\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eaAQAB\u0002A\u0002]\u00022\u0001O\u001f'\u001d\tI4H\u0004\u0002/u%\t\u0011$\u0003\u0002=1\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005\r\u0019V-\u001d\u0006\u0003yaAC\"A!E\u000b\u001eC%jS'O!F\u0003\"a\u0005\"\n\u0005\r+!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0002\r\u0006\u0011IE\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO].-A\u0019|'/\\1u;&\u0002S\u0006\t)beN,7\u000f\t;iK\u0002\u00027\u000f\u001e:aA\u0015D\bO]3tg&|g\u000eI<ji\"\u0004C\u000f[3!A\u001a|'/\\1uA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011u_\u0002\n\u0007\u0005^5nK:R\u0001\u0005\t\u0011!\u0013\u001a\u0004\u0003MZ8s[\u0006$\b\rI5tA5\fGNZ8s[\u0016$\u0007e\u001c:!SR\u001c\b%\u00199qY&\u001c\u0017\r^5p]\u0002\"w.Z:!]>$\bE]3tk2$\b%\u001b8!C\u0002:X\r\u001c7!M>\u0014X.\u001a3!i&lW\r\f\u0011uQ\u0016\u0004c-\u001e8di&|gN\u0003\u0011!A\u0001\u0012X\r^;s]N\u0004c*\u0016'M]\u0001\u0012\u0015\u0010\t3fM\u0006,H\u000e\u001e\u0017!SR\u0004cm\u001c7m_^\u001c\beY1ti&tw\r\t:vY\u0016\u001c\b\u0005^8!C\u0002\"\u0018.\\3!S\u001a\u0004C\u000f[3!A\u001a|'/\\1uA\u0002J7\u000fI8nSR$X\r\u001a\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0003%\u000b!q\u0002\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!\u0003\u0002\u001aHO]5oO\u0002\"x\u000e\t2fAA\f'o]3eAQ|\u0007\u0005^5nK:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ8s[\u0006$\b%\f\u0011US6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014h\u000e\t;pA\u0019|G\u000e\\8x]\u0001\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006Z1uKRLW.Z\u0017qCR$XM\u001d8/QRlGN\t ECR,G/[7fAA\u000bG\u000f^3s]Ndt&\u0019 !M>\u0014\bE^1mS\u0012T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014hn\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0002\u0019\u0006\tiK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(aAR\u0014G\r\u001e1a9\u0002\u0004'M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0004GO\u00193uA\u0002d\u0006\r\u00192\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013G\r\u00182a9\u0002TGL\u001d:seJ\u0014h\n\u0017!O!Ce&\\7/gNt3kU*T'N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112ei\n\u0004G\u000f\u00196]eJ\u0014(O\u001d:\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":cm\\8(Y\u0001:\u0003\n\u0013\u001en[j\u001a8oJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\nq*\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0003I\u000bQ\u0001\u000e\u00182]ABC\u0002A!E\u000b\u001eC%jS'O!F\u0003")
public final class TryToTimeExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return TryToTimeExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return TryToTimeExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return TryToTimeExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return TryToTimeExpressionBuilder$.MODULE$.functionSignature();
    }
}

