/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.types.variant.VariantSchema;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005U3aa\u0002\u0005!\u0002\u001b9\u0002\"\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000f&\u0011%1\u0003A!A!\u0002\u00139C\u0006C\u0005.\u0001\t\u0005\t\u0015!\u0003/o!)\u0001\b\u0001C\u0001s!1a\b\u0001Q\u0001\naAQa\u0010\u0001\u0005B\u0001\u00131\"\u0011:sCf\u0014V-\u00193fe*\u0011\u0011BC\u0001\ba\u0006\u0014\u0018/^3u\u0015\tYA\"A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0007\u000f\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011DG\u0007\u0002\u0011%\u00111\u0004\u0003\u0002\u0015!\u0006\u0014\u0018/^3u-\u0006\u0014\u0018.\u00198u%\u0016\fG-\u001a:\u0002\rM\u001c\u0007.Z7b!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0004wCJL\u0017M\u001c;\u000b\u0005\t\u0002\u0012!\u0002;za\u0016\u001c\u0018B\u0001\u0013 \u000551\u0016M]5b]R\u001c6\r[3nC&\u0011ADG\u0001\u000bi\u0006\u0014x-\u001a;UsB,\u0007C\u0001\u0015+\u001b\u0005I#B\u0001\u0012\u000f\u0013\tY\u0013FA\u0005BeJ\f\u0017\u0010V=qK&\u0011aEG\u0001\tG\u0006\u001cH/\u0011:hgB\u0011q&N\u0007\u0002a)\u0011\u0001%\r\u0006\u0003eM\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011AGD\u0001\tG\u0006$\u0018\r\\=ti&\u0011a\u0007\r\u0002\u0010-\u0006\u0014\u0018.\u00198u\u0007\u0006\u001cH/\u0011:hg&\u0011QFG\u0001\u0007y%t\u0017\u000e\u001e \u0015\tiZD(\u0010\t\u00033\u0001AQ\u0001\b\u0003A\u0002uAQA\n\u0003A\u0002\u001dBQ!\f\u0003A\u00029\nQ\"\u001a7f[\u0016tGOU3bI\u0016\u0014\u0018!\u0004:fC\u00124%o\\7UsB,G\rF\u0002B\u000f6\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u00131!\u00118z\u0011\u0015Ae\u00011\u0001J\u0003\r\u0011xn\u001e\t\u0003\u0015.k\u0011aM\u0005\u0003\u0019N\u00121\"\u00138uKJt\u0017\r\u001c*po\")aJ\u0002a\u0001\u001f\u0006\u0001Bo\u001c9MKZ,G.T3uC\u0012\fG/\u0019\t\u0004\u0005B\u0013\u0016BA)D\u0005\u0015\t%O]1z!\t\u00115+\u0003\u0002U\u0007\n!!)\u001f;f\u0001")
public final class ArrayReader
extends ParquetVariantReader {
    private final ParquetVariantReader elementReader;

    @Override
    public Object readFromTyped(InternalRow row, byte[] topLevelMetadata) {
        if (super.schema().arraySchema == null) {
            return this.invalidCast(row, topLevelMetadata);
        }
        int elementNumFields = super.schema().arraySchema.numFields;
        ArrayData arr = row.getArray(super.schema().typedIdx);
        int size = arr.numElements();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            if (arr.isNullAt(i)) {
                throw QueryExecutionErrors$.MODULE$.malformedVariant();
            }
            result[i] = this.elementReader.read(arr.getStruct(i, elementNumFields), topLevelMetadata);
        }
        return new GenericArrayData(result);
    }

    public ArrayReader(VariantSchema schema, ArrayType targetType, VariantCastArgs castArgs) {
        super(schema, (DataType)targetType, castArgs);
        this.elementReader = super.schema().arraySchema != null ? ParquetVariantReader$.MODULE$.apply(super.schema().arraySchema, ((ArrayType)super.targetType()).elementType(), super.castArgs(), ParquetVariantReader$.MODULE$.apply$default$4()) : null;
    }
}

