/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.types;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.ExtensionTypeVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float2Vector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.ViewVarBinaryVector;
import org.apache.arrow.vector.ViewVarCharVector;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.LargeListViewVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.ListViewVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.RunEndEncodedVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.BigIntWriterImpl;
import org.apache.arrow.vector.complex.impl.BitWriterImpl;
import org.apache.arrow.vector.complex.impl.DateDayWriterImpl;
import org.apache.arrow.vector.complex.impl.DateMilliWriterImpl;
import org.apache.arrow.vector.complex.impl.Decimal256WriterImpl;
import org.apache.arrow.vector.complex.impl.DecimalWriterImpl;
import org.apache.arrow.vector.complex.impl.DenseUnionWriter;
import org.apache.arrow.vector.complex.impl.DurationWriterImpl;
import org.apache.arrow.vector.complex.impl.FixedSizeBinaryWriterImpl;
import org.apache.arrow.vector.complex.impl.Float2WriterImpl;
import org.apache.arrow.vector.complex.impl.Float4WriterImpl;
import org.apache.arrow.vector.complex.impl.Float8WriterImpl;
import org.apache.arrow.vector.complex.impl.IntWriterImpl;
import org.apache.arrow.vector.complex.impl.IntervalDayWriterImpl;
import org.apache.arrow.vector.complex.impl.IntervalMonthDayNanoWriterImpl;
import org.apache.arrow.vector.complex.impl.IntervalYearWriterImpl;
import org.apache.arrow.vector.complex.impl.LargeVarBinaryWriterImpl;
import org.apache.arrow.vector.complex.impl.LargeVarCharWriterImpl;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.SmallIntWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeMicroWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeMilliWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeNanoWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeSecWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampMicroTZWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampMicroWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampMilliTZWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampMilliWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampNanoTZWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampNanoWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampSecTZWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampSecWriterImpl;
import org.apache.arrow.vector.complex.impl.TinyIntWriterImpl;
import org.apache.arrow.vector.complex.impl.UInt1WriterImpl;
import org.apache.arrow.vector.complex.impl.UInt2WriterImpl;
import org.apache.arrow.vector.complex.impl.UInt4WriterImpl;
import org.apache.arrow.vector.complex.impl.UInt8WriterImpl;
import org.apache.arrow.vector.complex.impl.UnionLargeListViewWriter;
import org.apache.arrow.vector.complex.impl.UnionLargeListWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.complex.impl.UnionWriter;
import org.apache.arrow.vector.complex.impl.VarBinaryWriterImpl;
import org.apache.arrow.vector.complex.impl.VarCharWriterImpl;
import org.apache.arrow.vector.complex.impl.ViewVarBinaryWriterImpl;
import org.apache.arrow.vector.complex.impl.ViewVarCharWriterImpl;
import org.apache.arrow.vector.complex.writer.FieldWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.CallBack;

public class Types {
    public static MinorType getMinorTypeForArrowType(ArrowType arrowType) {
        return arrowType.accept(new ArrowType.ArrowTypeVisitor<MinorType>(){

            @Override
            public MinorType visit(ArrowType.Null type) {
                return MinorType.NULL;
            }

            @Override
            public MinorType visit(ArrowType.Struct type) {
                return MinorType.STRUCT;
            }

            @Override
            public MinorType visit(ArrowType.List type) {
                return MinorType.LIST;
            }

            @Override
            public MinorType visit(ArrowType.FixedSizeList type) {
                return MinorType.FIXED_SIZE_LIST;
            }

            @Override
            public MinorType visit(ArrowType.Union type) {
                switch (type.getMode()) {
                    case Sparse: {
                        return MinorType.UNION;
                    }
                    case Dense: {
                        return MinorType.DENSEUNION;
                    }
                }
                throw new IllegalArgumentException("only Dense or Sparse unions supported: " + String.valueOf(type));
            }

            @Override
            public MinorType visit(ArrowType.Map type) {
                return MinorType.MAP;
            }

            @Override
            public MinorType visit(ArrowType.LargeList type) {
                return MinorType.LARGELIST;
            }

            @Override
            public MinorType visit(ArrowType.Int type) {
                switch (type.getBitWidth()) {
                    case 8: {
                        return type.getIsSigned() ? MinorType.TINYINT : MinorType.UINT1;
                    }
                    case 16: {
                        return type.getIsSigned() ? MinorType.SMALLINT : MinorType.UINT2;
                    }
                    case 32: {
                        return type.getIsSigned() ? MinorType.INT : MinorType.UINT4;
                    }
                    case 64: {
                        return type.getIsSigned() ? MinorType.BIGINT : MinorType.UINT8;
                    }
                }
                throw new IllegalArgumentException("only 8, 16, 32, 64 supported: " + String.valueOf(type));
            }

            @Override
            public MinorType visit(ArrowType.FloatingPoint type) {
                switch (type.getPrecision()) {
                    case HALF: {
                        return MinorType.FLOAT2;
                    }
                    case SINGLE: {
                        return MinorType.FLOAT4;
                    }
                    case DOUBLE: {
                        return MinorType.FLOAT8;
                    }
                }
                throw new IllegalArgumentException("unknown precision: " + String.valueOf(type));
            }

            @Override
            public MinorType visit(ArrowType.Utf8 type) {
                return MinorType.VARCHAR;
            }

            @Override
            public MinorType visit(ArrowType.Utf8View type) {
                return MinorType.VIEWVARCHAR;
            }

            @Override
            public MinorType visit(ArrowType.LargeUtf8 type) {
                return MinorType.LARGEVARCHAR;
            }

            @Override
            public MinorType visit(ArrowType.Binary type) {
                return MinorType.VARBINARY;
            }

            @Override
            public MinorType visit(ArrowType.BinaryView type) {
                return MinorType.VIEWVARBINARY;
            }

            @Override
            public MinorType visit(ArrowType.LargeBinary type) {
                return MinorType.LARGEVARBINARY;
            }

            @Override
            public MinorType visit(ArrowType.Bool type) {
                return MinorType.BIT;
            }

            @Override
            public MinorType visit(ArrowType.Decimal type) {
                if (type.getBitWidth() == 256) {
                    return MinorType.DECIMAL256;
                }
                return MinorType.DECIMAL;
            }

            @Override
            public MinorType visit(ArrowType.FixedSizeBinary type) {
                return MinorType.FIXEDSIZEBINARY;
            }

            @Override
            public MinorType visit(ArrowType.Date type) {
                switch (type.getUnit()) {
                    case DAY: {
                        return MinorType.DATEDAY;
                    }
                    case MILLISECOND: {
                        return MinorType.DATEMILLI;
                    }
                }
                throw new IllegalArgumentException("unknown unit: " + String.valueOf(type));
            }

            @Override
            public MinorType visit(ArrowType.Time type) {
                switch (type.getUnit()) {
                    case SECOND: {
                        return MinorType.TIMESEC;
                    }
                    case MILLISECOND: {
                        return MinorType.TIMEMILLI;
                    }
                    case MICROSECOND: {
                        return MinorType.TIMEMICRO;
                    }
                    case NANOSECOND: {
                        return MinorType.TIMENANO;
                    }
                }
                throw new IllegalArgumentException("unknown unit: " + String.valueOf(type));
            }

            @Override
            public MinorType visit(ArrowType.Timestamp type) {
                String tz = type.getTimezone();
                switch (type.getUnit()) {
                    case SECOND: {
                        return tz == null ? MinorType.TIMESTAMPSEC : MinorType.TIMESTAMPSECTZ;
                    }
                    case MILLISECOND: {
                        return tz == null ? MinorType.TIMESTAMPMILLI : MinorType.TIMESTAMPMILLITZ;
                    }
                    case MICROSECOND: {
                        return tz == null ? MinorType.TIMESTAMPMICRO : MinorType.TIMESTAMPMICROTZ;
                    }
                    case NANOSECOND: {
                        return tz == null ? MinorType.TIMESTAMPNANO : MinorType.TIMESTAMPNANOTZ;
                    }
                }
                throw new IllegalArgumentException("unknown unit: " + String.valueOf(type));
            }

            @Override
            public MinorType visit(ArrowType.Interval type) {
                switch (type.getUnit()) {
                    case DAY_TIME: {
                        return MinorType.INTERVALDAY;
                    }
                    case YEAR_MONTH: {
                        return MinorType.INTERVALYEAR;
                    }
                    case MONTH_DAY_NANO: {
                        return MinorType.INTERVALMONTHDAYNANO;
                    }
                }
                throw new IllegalArgumentException("unknown unit: " + String.valueOf(type));
            }

            @Override
            public MinorType visit(ArrowType.Duration type) {
                return MinorType.DURATION;
            }

            @Override
            public MinorType visit(ArrowType.ListView type) {
                return MinorType.LISTVIEW;
            }

            @Override
            public MinorType visit(ArrowType.LargeListView type) {
                return MinorType.LARGELISTVIEW;
            }

            @Override
            public MinorType visit(ArrowType.ExtensionType type) {
                return MinorType.EXTENSIONTYPE;
            }

            @Override
            public MinorType visit(ArrowType.RunEndEncoded type) {
                return MinorType.RUNENDENCODED;
            }
        });
    }

    public static enum MinorType {
        NULL(ArrowType.Null.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new NullVector(field.getName());
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return null;
            }
        }
        ,
        STRUCT(ArrowType.Struct.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new StructVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new NullableStructWriter((StructVector)vector);
            }
        }
        ,
        TINYINT(new ArrowType.Int(8, true)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TinyIntVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TinyIntWriterImpl((TinyIntVector)vector);
            }
        }
        ,
        SMALLINT(new ArrowType.Int(16, true)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new SmallIntVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new SmallIntWriterImpl((SmallIntVector)vector);
            }
        }
        ,
        INT(new ArrowType.Int(32, true)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new IntVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new IntWriterImpl((IntVector)vector);
            }
        }
        ,
        BIGINT(new ArrowType.Int(64, true)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new BigIntVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new BigIntWriterImpl((BigIntVector)vector);
            }
        }
        ,
        DATEDAY(new ArrowType.Date(DateUnit.DAY)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new DateDayVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new DateDayWriterImpl((DateDayVector)vector);
            }
        }
        ,
        DATEMILLI(new ArrowType.Date(DateUnit.MILLISECOND)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new DateMilliVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new DateMilliWriterImpl((DateMilliVector)vector);
            }
        }
        ,
        TIMESEC(new ArrowType.Time(TimeUnit.SECOND, 32)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeSecVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeSecWriterImpl((TimeSecVector)vector);
            }
        }
        ,
        TIMEMILLI(new ArrowType.Time(TimeUnit.MILLISECOND, 32)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeMilliVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeMilliWriterImpl((TimeMilliVector)vector);
            }
        }
        ,
        TIMEMICRO(new ArrowType.Time(TimeUnit.MICROSECOND, 64)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeMicroVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeMicroWriterImpl((TimeMicroVector)vector);
            }
        }
        ,
        TIMENANO(new ArrowType.Time(TimeUnit.NANOSECOND, 64)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeNanoVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeNanoWriterImpl((TimeNanoVector)vector);
            }
        }
        ,
        TIMESTAMPSEC(new ArrowType.Timestamp(TimeUnit.SECOND, null)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampSecVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampSecWriterImpl((TimeStampSecVector)vector);
            }
        }
        ,
        TIMESTAMPMILLI(new ArrowType.Timestamp(TimeUnit.MILLISECOND, null)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampMilliVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampMilliWriterImpl((TimeStampMilliVector)vector);
            }
        }
        ,
        TIMESTAMPMICRO(new ArrowType.Timestamp(TimeUnit.MICROSECOND, null)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampMicroVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampMicroWriterImpl((TimeStampMicroVector)vector);
            }
        }
        ,
        TIMESTAMPNANO(new ArrowType.Timestamp(TimeUnit.NANOSECOND, null)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampNanoVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampNanoWriterImpl((TimeStampNanoVector)vector);
            }
        }
        ,
        INTERVALDAY(new ArrowType.Interval(IntervalUnit.DAY_TIME)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new IntervalDayVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new IntervalDayWriterImpl((IntervalDayVector)vector);
            }
        }
        ,
        INTERVALMONTHDAYNANO(new ArrowType.Interval(IntervalUnit.MONTH_DAY_NANO)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new IntervalMonthDayNanoVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new IntervalMonthDayNanoWriterImpl((IntervalMonthDayNanoVector)vector);
            }
        }
        ,
        DURATION(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new DurationVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new DurationWriterImpl((DurationVector)vector);
            }
        }
        ,
        INTERVALYEAR(new ArrowType.Interval(IntervalUnit.YEAR_MONTH)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new IntervalYearVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new IntervalYearWriterImpl((IntervalYearVector)vector);
            }
        }
        ,
        FLOAT2(new ArrowType.FloatingPoint(FloatingPointPrecision.HALF)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new Float2Vector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new Float2WriterImpl((Float2Vector)vector);
            }
        }
        ,
        FLOAT4(new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new Float4Vector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new Float4WriterImpl((Float4Vector)vector);
            }
        }
        ,
        FLOAT8(new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new Float8Vector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new Float8WriterImpl((Float8Vector)vector);
            }
        }
        ,
        BIT(ArrowType.Bool.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new BitVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new BitWriterImpl((BitVector)vector);
            }
        }
        ,
        VARCHAR(ArrowType.Utf8.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new VarCharVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new VarCharWriterImpl((VarCharVector)vector);
            }
        }
        ,
        VIEWVARCHAR(ArrowType.Utf8View.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new ViewVarCharVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new ViewVarCharWriterImpl((ViewVarCharVector)vector);
            }
        }
        ,
        LARGEVARCHAR(ArrowType.LargeUtf8.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new LargeVarCharVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new LargeVarCharWriterImpl((LargeVarCharVector)vector);
            }
        }
        ,
        LARGEVARBINARY(ArrowType.LargeBinary.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new LargeVarBinaryVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new LargeVarBinaryWriterImpl((LargeVarBinaryVector)vector);
            }
        }
        ,
        VARBINARY(ArrowType.Binary.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new VarBinaryVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new VarBinaryWriterImpl((VarBinaryVector)vector);
            }
        }
        ,
        VIEWVARBINARY(ArrowType.BinaryView.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new ViewVarBinaryVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new ViewVarBinaryWriterImpl((ViewVarBinaryVector)vector);
            }
        }
        ,
        DECIMAL(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new DecimalVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new DecimalWriterImpl((DecimalVector)vector);
            }
        }
        ,
        DECIMAL256(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new Decimal256Vector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new Decimal256WriterImpl((Decimal256Vector)vector);
            }
        }
        ,
        FIXEDSIZEBINARY(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new FixedSizeBinaryVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new FixedSizeBinaryWriterImpl((FixedSizeBinaryVector)vector);
            }
        }
        ,
        UINT1(new ArrowType.Int(8, false)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new UInt1Vector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UInt1WriterImpl((UInt1Vector)vector);
            }
        }
        ,
        UINT2(new ArrowType.Int(16, false)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new UInt2Vector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UInt2WriterImpl((UInt2Vector)vector);
            }
        }
        ,
        UINT4(new ArrowType.Int(32, false)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new UInt4Vector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UInt4WriterImpl((UInt4Vector)vector);
            }
        }
        ,
        UINT8(new ArrowType.Int(64, false)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new UInt8Vector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UInt8WriterImpl((UInt8Vector)vector);
            }
        }
        ,
        LIST(ArrowType.List.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new ListVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UnionListWriter((ListVector)vector);
            }
        }
        ,
        LISTVIEW(ArrowType.ListView.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new ListViewVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UnionListWriter((ListVector)vector);
            }
        }
        ,
        LARGELIST(ArrowType.LargeList.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new LargeListVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UnionLargeListWriter((LargeListVector)vector);
            }
        }
        ,
        LARGELISTVIEW(ArrowType.LargeListView.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new LargeListViewVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UnionLargeListViewWriter((LargeListViewVector)vector);
            }
        }
        ,
        FIXED_SIZE_LIST(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new FixedSizeListVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                throw new UnsupportedOperationException("FieldWriter not implemented for FixedSizeList type");
            }
        }
        ,
        UNION(new ArrowType.Union(UnionMode.Sparse, null)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                if (field.getFieldType().getDictionary() != null) {
                    throw new UnsupportedOperationException("Dictionary encoding not supported for complex types");
                }
                return new UnionVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UnionWriter((UnionVector)vector);
            }
        }
        ,
        DENSEUNION(new ArrowType.Union(UnionMode.Dense, null)){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                if (field.getFieldType().getDictionary() != null) {
                    throw new UnsupportedOperationException("Dictionary encoding not supported for complex types");
                }
                return new DenseUnionVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new DenseUnionWriter((DenseUnionVector)vector);
            }
        }
        ,
        MAP(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new MapVector(field.getName(), allocator, field.getFieldType(), schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UnionMapWriter((MapVector)vector);
            }
        }
        ,
        TIMESTAMPSECTZ(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampSecTZVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampSecTZWriterImpl((TimeStampSecTZVector)vector);
            }
        }
        ,
        TIMESTAMPMILLITZ(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampMilliTZVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampMilliTZWriterImpl((TimeStampMilliTZVector)vector);
            }
        }
        ,
        TIMESTAMPMICROTZ(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampMicroTZVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampMicroTZWriterImpl((TimeStampMicroTZVector)vector);
            }
        }
        ,
        TIMESTAMPNANOTZ(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampNanoTZVector(field, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampNanoTZWriterImpl((TimeStampNanoTZVector)vector);
            }
        }
        ,
        EXTENSIONTYPE(null){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return ((ArrowType.ExtensionType)field.getFieldType().getType()).getNewVector(field.getName(), field.getFieldType(), allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return ((ExtensionTypeVector)vector).getUnderlyingVector().getMinorType().getNewFieldWriter(vector);
            }
        }
        ,
        RUNENDENCODED(ArrowType.RunEndEncoded.INSTANCE){

            @Override
            public FieldVector getNewVector(Field field, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new RunEndEncodedVector(field, allocator, schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                throw new UnsupportedOperationException("FieldWriter for run-end encoded vector is not implemented yet.");
            }
        };

        private final ArrowType type;

        private MinorType(ArrowType type) {
            this.type = type;
        }

        public final ArrowType getType() {
            if (this.type == null) {
                throw new UnsupportedOperationException("Cannot get simple type for type " + this.name());
            }
            return this.type;
        }

        public final FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
            return this.getNewVector(new Field(name, fieldType, null), allocator, schemaChangeCallback);
        }

        public abstract FieldVector getNewVector(Field var1, BufferAllocator var2, CallBack var3);

        public abstract FieldWriter getNewFieldWriter(ValueVector var1);
    }
}

