/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.io.grpc.netty;

import javax.annotation.Nullable;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.io.grpc.Attributes;
import org.sparkproject.io.grpc.ChannelLogger;
import org.sparkproject.io.grpc.Internal;
import org.sparkproject.io.grpc.InternalChannelz;
import org.sparkproject.io.netty.channel.ChannelPromise;
import org.sparkproject.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import org.sparkproject.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import org.sparkproject.io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.sparkproject.io.netty.handler.codec.http2.Http2Settings;

@Internal
public abstract class GrpcHttp2ConnectionHandler
extends Http2ConnectionHandler {
    @Nullable
    protected final ChannelPromise channelUnused;
    private final ChannelLogger negotiationLogger;

    protected GrpcHttp2ConnectionHandler(ChannelPromise channelUnused, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, ChannelLogger negotiationLogger) {
        super(decoder, encoder, initialSettings);
        this.channelUnused = channelUnused;
        this.negotiationLogger = negotiationLogger;
    }

    @Deprecated
    public void handleProtocolNegotiationCompleted(Attributes attrs) {
        this.handleProtocolNegotiationCompleted(attrs, null);
    }

    public void handleProtocolNegotiationCompleted(Attributes attrs, InternalChannelz.Security securityInfo) {
    }

    public ChannelLogger getNegotiationLogger() {
        Preconditions.checkState(this.negotiationLogger != null, "NegotiationLogger must not be null");
        return this.negotiationLogger;
    }

    public void notifyUnused() {
        this.channelUnused.setSuccess(null);
    }

    public Attributes getEagAttributes() {
        return Attributes.EMPTY;
    }

    public String getAuthority() {
        throw new UnsupportedOperationException();
    }
}

