/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VectorizationCondition {
    private final boolean flag;
    private final String conditionName;

    public VectorizationCondition(boolean flag, String conditionName) {
        this.flag = flag;
        this.conditionName = conditionName;
    }

    public boolean getFlag() {
        return this.flag;
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public static List<String> getConditionsMet(VectorizationCondition[] conditions) {
        ArrayList<String> metList = new ArrayList<String>();
        for (VectorizationCondition condition : conditions) {
            if (!condition.getFlag()) continue;
            metList.add(condition.getConditionName() + " IS true");
        }
        return metList;
    }

    public static List<String> getConditionsNotMet(VectorizationCondition[] conditions) {
        ArrayList<String> notMetList = new ArrayList<String>();
        for (VectorizationCondition condition : conditions) {
            if (condition.getFlag()) continue;
            notMetList.add(condition.getConditionName() + " IS false");
        }
        return notMetList;
    }

    public static List<String> addBooleans(List<String> conditions, boolean flag) {
        ArrayList<String> result = new ArrayList<String>(conditions.size());
        for (String condition : conditions) {
            result.add(condition + " IS " + flag);
        }
        return result;
    }

    public static List<String> getConditionsSupported(boolean isSupported) {
        return Arrays.asList("Supported IS " + isSupported);
    }
}

