/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.checkpointing;

import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.AsyncOffsetSeqLog$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqLog;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001B\f\u0019\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"B+\u0001\t\u00031\u0006bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B0\t\u000f\u0019\u0004!\u0019!C\u0005O\"1a\u000e\u0001Q\u0001\n!Dqa\u001c\u0001C\u0002\u0013\u0005\u0001\u000f\u0003\u0004u\u0001\u0001\u0006I!\u001d\u0005\u0006k\u0002!\tA\u001e\u0005\u0006y\u0002!\t! \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002L\u0001!\t!!\u0014\b\u0013\u0005U\u0003$!A\t\u0002\u0005]c\u0001C\f\u0019\u0003\u0003E\t!!\u0017\t\rU#B\u0011AA1\u0011%\t\u0019\u0007FI\u0001\n\u0003\t)GA\tBgft7m\u00144gg\u0016$8+Z9M_\u001eT!!\u0007\u000e\u0002\u001b\rDWmY6q_&tG/\u001b8h\u0015\tYB$A\u0005tiJ,\u0017-\\5oO*\u0011QDH\u0001\nKb,7-\u001e;j_:T!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0015\u0011\u0005%RS\"\u0001\r\n\u0005-B\"\u0001D(gMN,GoU3r\u0019><\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001\u00180\u001b\u0005q\u0012B\u0001\u0019\u001f\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005MbdB\u0001\u001b;!\t)\u0004(D\u00017\u0015\t9d%\u0001\u0004=e>|GO\u0010\u0006\u0002s\u0005)1oY1mC&\u00111\bO\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<q\u0005yQ\r_3dkR|'oU3sm&\u001cW\r\u0005\u0002B\u00116\t!I\u0003\u0002D\t\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u00153\u0015\u0001B;uS2T\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\u0005\n\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0003YygMZ:fi\u000e{W.\\5u\u0013:$XM\u001d<bY6\u001b\bC\u0001'N\u001b\u0005A\u0014B\u0001(9\u0005\u0011auN\\4\u0002\u000b\rdwnY6\u0011\u0005E\u001bV\"\u0001*\u000b\u0005\u0015\u0003\u0013B\u0001+S\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}Q1q\u000bW-[7r\u0003\"!\u000b\u0001\t\u000b12\u0001\u0019A\u0017\t\u000bE2\u0001\u0019\u0001\u001a\t\u000b}2\u0001\u0019\u0001!\t\u000b)3\u0001\u0019A&\t\u000f=3\u0001\u0013!a\u0001!\u0006\u0019\u0002/\u001a8eS:<wJ\u001a4tKR<&/\u001b;fgV\tq\f\u0005\u0003BA.\u0013\u0017BA1C\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004\u0003\u000e\\\u0015B\u00013C\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/Z\u0001\u0015a\u0016tG-\u001b8h\u001f\u001a47/\u001a;Xe&$Xm\u001d\u0011\u000271\f7\u000f^\"p[6LG/S:tk\u0016$G+[7fgR\fW\u000e]'t+\u0005A\u0007CA5m\u001b\u0005Q'BA6C\u0003\u0019\tGo\\7jG&\u0011QN\u001b\u0002\u000b\u0003R|W.[2M_:<\u0017\u0001\b7bgR\u001cu.\\7ji&\u001b8/^3e)&lWm\u001d;b[Bl5\u000fI\u0001\u0018oJLG\u000f^3o)>$UO]1cY\u0016\u001cFo\u001c:bO\u0016,\u0012!\u001d\t\u0004\u0003J\\\u0015BA:C\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G\rR3rk\u0016\f\u0001d\u001e:jiR,g\u000eV8EkJ\f'\r\\3Ti>\u0014\u0018mZ3!\u0003M9W\r^!ts:\u001cwJ\u001a4tKR<&/\u001b;f)\t9(\u0010E\u0002Mq\nL!!\u001f\u001d\u0003\r=\u0003H/[8o\u0011\u0015YX\u00021\u0001L\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\faC]3n_Z,\u0017i]=oG>3gm]3u/JLG/\u001a\u000b\u0004}\u0006\r\u0001C\u0001'\u0000\u0013\r\t\t\u0001\u000f\u0002\u0005+:LG\u000fC\u0003|\u001d\u0001\u00071*\u0001\u0005bI\u0012\f5/\u001f8d)\u0019\tI!a\u0006\u0002\u001aA!\u0011iYA\u0006!\u0019a\u0015QB&\u0002\u0012%\u0019\u0011q\u0002\u001d\u0003\rQ+\b\u000f\\33!\ra\u00151C\u0005\u0004\u0003+A$a\u0002\"p_2,\u0017M\u001c\u0005\u0006w>\u0001\ra\u0013\u0005\b\u00037y\u0001\u0019AA\u000f\u0003!iW\r^1eCR\f\u0007cA\u0015\u0002 %\u0019\u0011\u0011\u0005\r\u0003\u001b=3gm]3u'\u0016\f()Y:f\u0003a\tG\r\u001a(fo\n\u000bGo\u00195CsN#(/Z1n\u0003NLhn\u0019\u000b\u0005\u0003O\t\t\u0005\u0006\u0003\u0002*\u0005-\u0002\u0003B!d\u0003#Aq!!\f\u0011\u0001\u0004\ty#\u0001\u0002g]B1A*!\r\u00026yL1!a\r9\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tYDR\u0001\u0003S>LA!a\u0010\u0002:\taq*\u001e;qkR\u001cFO]3b[\")1\u0010\u0005a\u0001\u0017\u0006)\u0001/\u001e:hKR\u0019a0a\u0012\t\r\u0005%\u0013\u00031\u0001L\u0003A!\bN]3tQ>dGMQ1uG\"LE-A\fqK:$\u0017N\\4Bgft7m\u00144gg\u0016$xK]5uKR\u0011\u0011q\n\t\u0004\u0019\u0006E\u0013bAA*q\t\u0019\u0011J\u001c;\u0002#\u0005\u001b\u0018P\\2PM\u001a\u001cX\r^*fc2{w\r\u0005\u0002*)M\u0019A#a\u0017\u0011\u00071\u000bi&C\u0002\u0002`a\u0012a!\u00118z%\u00164GCAA,\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\r\u0016\u0004!\u0006%4FAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0004(\u0001\u0006b]:|G/\u0019;j_:LA!!\u001f\u0002p\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class AsyncOffsetSeqLog
extends OffsetSeqLog {
    private final ThreadPoolExecutor executorService;
    private final long offsetCommitIntervalMs;
    private final Clock clock;
    private final ConcurrentHashMap<Object, CompletableFuture<Object>> pendingOffsetWrites;
    private final AtomicLong lastCommitIssuedTimestampMs;
    private final ConcurrentLinkedDeque<Object> writtenToDurableStorage;

    public static Clock $lessinit$greater$default$5() {
        return AsyncOffsetSeqLog$.MODULE$.$lessinit$greater$default$5();
    }

    private ConcurrentHashMap<Object, CompletableFuture<Object>> pendingOffsetWrites() {
        return this.pendingOffsetWrites;
    }

    private AtomicLong lastCommitIssuedTimestampMs() {
        return this.lastCommitIssuedTimestampMs;
    }

    public ConcurrentLinkedDeque<Object> writtenToDurableStorage() {
        return this.writtenToDurableStorage;
    }

    public Option<CompletableFuture<Object>> getAsyncOffsetWrite(long batchId) {
        return Option$.MODULE$.apply(this.pendingOffsetWrites().get(BoxesRunTime.boxToLong((long)batchId)));
    }

    public void removeAsyncOffsetWrite(long batchId) {
        this.pendingOffsetWrites().remove(BoxesRunTime.boxToLong((long)batchId));
    }

    public CompletableFuture<Tuple2<Object, Object>> addAsync(long batchId2, OffsetSeqBase metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable)() -> "'null' metadata cannot written to a metadata log");
        long lastIssuedTs = this.lastCommitIssuedTimestampMs().get();
        CompletableFuture<Tuple2.mcJZ.sp> future = this.offsetCommitIntervalMs > 0L ? (lastIssuedTs == -1L || lastIssuedTs + this.offsetCommitIntervalMs <= this.clock.getTimeMillis() ? this.issueAsyncWrite$1(batchId2, metadata).thenApply(batchId -> AsyncOffsetSeqLog.$anonfun$addAsync$4(BoxesRunTime.unboxToLong((Object)batchId))) : CompletableFuture.completedFuture(new Tuple2.mcJZ.sp(batchId2, false))) : this.issueAsyncWrite$1(batchId2, metadata).thenApply(batchId -> AsyncOffsetSeqLog.$anonfun$addAsync$5(BoxesRunTime.unboxToLong((Object)batchId)));
        this.batchCache().put(BoxesRunTime.boxToLong((long)batchId2), metadata);
        return future;
    }

    private CompletableFuture<Object> addNewBatchByStreamAsync(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            future.complete(BoxesRunTime.boxToBoolean((boolean)false));
            return future;
        }
        this.executorService.submit(new Runnable(this, batchMetadataFile, future, fn, batchId){
            private final /* synthetic */ AsyncOffsetSeqLog $outer;
            private final Path batchMetadataFile$1;
            private final CompletableFuture future$1;
            private final Function1 fn$1;
            private final long batchId$2;

            public void run() {
                block3: {
                    try {
                        if (this.$outer.fileManager().exists(this.batchMetadataFile$1)) {
                            this.future$1.complete(BoxesRunTime.boxToBoolean((boolean)false));
                            break block3;
                        }
                        long start = System.currentTimeMillis();
                        this.$outer.write(this.batchMetadataFile$1, (Function1<OutputStream, BoxedUnit>)this.fn$1);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Offset commit for batch " + $this.batchId$2 + " took " + (System.currentTimeMillis() - start) + " ms to be persisted to durable storage");
                        this.$outer.writtenToDurableStorage().add(BoxesRunTime.boxToLong((long)this.batchId$2));
                        this.future$1.complete(BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    catch (Throwable e) {
                        this.$outer.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error while writing batch "}))).log((Seq)Nil$.MODULE$).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " to offset log"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)$this.batchId$2))})))), e);
                        this.future$1.completeExceptionally(e);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchMetadataFile$1 = batchMetadataFile$1;
                this.future$1 = future$1;
                this.fn$1 = fn$1;
                this.batchId$2 = batchId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.sql.execution.streaming.checkpointing.AsyncOffsetSeqLog$$anon$1 long ), $anonfun$run$2(org.apache.spark.sql.execution.streaming.checkpointing.AsyncOffsetSeqLog$$anon$1 )}, serializedLambda);
            }
        });
        return future;
    }

    @Override
    public void purge(long thresholdBatchId) {
        super.purge(thresholdBatchId);
    }

    public int pendingAsyncOffsetWrite() {
        return this.pendingOffsetWrites().size();
    }

    public static final /* synthetic */ long $anonfun$addAsync$3(long batchId$1, boolean ret) {
        if (ret) {
            return batchId$1;
        }
        throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(batchId$1);
    }

    private final CompletableFuture issueAsyncWrite$1(long batchId, OffsetSeqBase metadata$1) {
        this.lastCommitIssuedTimestampMs().set(this.clock.getTimeMillis());
        CompletionStage future = this.addNewBatchByStreamAsync(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            this.serialize(metadata$1, output);
            return BoxedUnit.UNIT;
        }).thenApply(ret -> BoxesRunTime.boxToLong((long)AsyncOffsetSeqLog.$anonfun$addAsync$3(batchId, BoxesRunTime.unboxToBoolean((Object)ret))));
        this.pendingOffsetWrites().put(BoxesRunTime.boxToLong((long)batchId), (CompletableFuture<Object>)future);
        return future;
    }

    public static final /* synthetic */ Tuple2 $anonfun$addAsync$4(long batchId) {
        return new Tuple2.mcJZ.sp(batchId, true);
    }

    public static final /* synthetic */ Tuple2 $anonfun$addAsync$5(long batchId) {
        return new Tuple2.mcJZ.sp(batchId, true);
    }

    public AsyncOffsetSeqLog(SparkSession sparkSession, String path, ThreadPoolExecutor executorService, long offsetCommitIntervalMs, Clock clock) {
        this.executorService = executorService;
        this.offsetCommitIntervalMs = offsetCommitIntervalMs;
        this.clock = clock;
        super(sparkSession, path);
        Predef$.MODULE$.assert(this.metadataCacheEnabled());
        this.pendingOffsetWrites = new ConcurrentHashMap();
        this.lastCommitIssuedTimestampMs = new AtomicLong(-1L);
        this.writtenToDurableStorage = new ConcurrentLinkedDeque(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)Predef$.MODULE$.wrapLongArray(this.listBatchesOnDisk()).toList()).asJavaCollection());
    }
}

