/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.sql.execution.streaming.state.RocksDBSnapshotFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBVersionSnapshotInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\t\u0012\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u0004J\u0001\u0001\u0006I!\f\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u00199\u0006\u0001)A\u0005\u0019\")\u0001\f\u0001C\u00013\")Q\f\u0001C!=\")q\f\u0001C\u0001A\")Q\u000e\u0001C\u0005]\")!\u0010\u0001C\u0005w\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!!\u0012\u0001\t\u0003\t9E\u0001\nS_\u000e\\7\u000f\u0012\"GS2,W*\u00199qS:<'B\u0001\n\u0014\u0003\u0015\u0019H/\u0019;f\u0015\t!R#A\u0005tiJ,\u0017-\\5oO*\u0011acF\u0001\nKb,7-\u001e;j_:T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t\u0011#A\tm_\u000e\fGNR5mK6\u000b\u0007\u000f]5oON,\u0012!\f\t\u0005]M*\u0004)D\u00010\u0015\t\u0001\u0014'A\u0004nkR\f'\r\\3\u000b\u0005I\u001a\u0013AC2pY2,7\r^5p]&\u0011Ag\f\u0002\u0004\u001b\u0006\u0004\bC\u0001\u001c>\u001d\t94\b\u0005\u00029G5\t\u0011H\u0003\u0002;?\u00051AH]8pizJ!\u0001P\u0012\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003y\r\u0002BAI!D\r&\u0011!i\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\t\"\u0015BA#$\u0005\u0011auN\\4\u0011\u0005):\u0015B\u0001%\u0012\u0005Q\u0011vnY6t\t\nKU.\\;uC\ndWMR5mK\u0006\u0011Bn\\2bY\u001aKG.Z'baBLgnZ:!\u0003Y\u0019h.\u00199tQ>$8\u000fU3oI&tw-\u00169m_\u0006$W#\u0001'\u0011\u00075\u0013F+D\u0001O\u0015\ty\u0005+\u0001\u0003vi&d'\"A)\u0002\t)\fg/Y\u0005\u0003':\u00131aU3u!\tQS+\u0003\u0002W#\tQ\"k\\2lg\u0012\u0013e+\u001a:tS>t7K\\1qg\"|G/\u00138g_\u000692O\\1qg\"|Go\u001d)f]\u0012LgnZ+qY>\fG\rI\u0001\u0006G2,\u0017M\u001d\u000b\u00025B\u0011!eW\u0005\u00039\u000e\u0012A!\u00168ji\u0006AAo\\*ue&tw\rF\u00016\u0003E9W\r\u001e#gg\u001aKG.\u001a$pe2{\u0017\r\u001a\u000b\u0005C\u0012L7\u000eE\u0002#E\u001aK!aY\u0012\u0003\r=\u0003H/[8o\u0011\u0015)\u0007\u00021\u0001g\u0003-1\u0017\u000e\\3NC:\fw-\u001a:\u0011\u0005):\u0017B\u00015\u0012\u0005I\u0011vnY6t\t\n3\u0015\u000e\\3NC:\fw-\u001a:\t\u000b)D\u0001\u0019A\u001b\u0002\u001b1|7-\u00197GS2,g*Y7f\u0011\u0015a\u0007\u00021\u0001D\u000351XM]:j_:$v\u000eT8bI\u0006\tr-\u001a;EMN4\u0015\u000e\\3G_J\u001c\u0016M^3\u0015\t\u0005|\u0007\u000f\u001f\u0005\u0006K&\u0001\rA\u001a\u0005\u0006c&\u0001\rA]\u0001\nY>\u001c\u0017\r\u001c$jY\u0016\u0004\"a\u001d<\u000e\u0003QT!!\u001e)\u0002\u0005%|\u0017BA<u\u0005\u00111\u0015\u000e\\3\t\u000beL\u0001\u0019A\"\u0002\u001bY,'o]5p]R{7+\u0019<f\u0003\t:W\r\u001e#gg\u001aKG.Z,ji\"LenY8na\u0006$\u0018NY5mSRL8\t[3dWR!\u0011\r`?\u007f\u0011\u0015)'\u00021\u0001g\u0011\u0015Q'\u00021\u00016\u0011\u0019y(\u00021\u0001\u0002\u0002\u0005q\u0011n]%oG>l\u0007/\u0019;jE2,\u0007c\u0002\u0012\u0002\u0004\r3\u0015qA\u0005\u0004\u0003\u000b\u0019#!\u0003$v]\u000e$\u0018n\u001c83!\r\u0011\u0013\u0011B\u0005\u0004\u0003\u0017\u0019#a\u0002\"p_2,\u0017M\\\u0001!aV\u0014x-Z%oG>l\u0007/\u0019;jE2,W*\u00199qS:<7OR8s\u0019>\fG\r\u0006\u0003\u0002\u0012\u0005\u0015\u0002CBA\n\u0003;\t\u0019C\u0004\u0003\u0002\u0016\u0005eab\u0001\u001d\u0002\u0018%\tA%C\u0002\u0002\u001c\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0005\u0005\"aA*fc*\u0019\u00111D\u0012\u0011\t\t\nU\u0007\u0011\u0005\u0006Y.\u0001\raQ\u0001\r[\u0006\u0004Hk\u001c#gg\u001aKG.\u001a\u000b\b5\u0006-\u0012QFA\u0019\u0011\u0015QG\u00021\u00016\u0011\u0019\ty\u0003\u0004a\u0001\r\u00069AMZ:GS2,\u0007BBA\u001a\u0019\u0001\u00071)A\u0004wKJ\u001c\u0018n\u001c8\u0002\rI,Wn\u001c<f)\rQ\u0016\u0011\b\u0005\u0006U6\u0001\r!N\u0001\u0013gft7mV5uQ2{7-\u00197Ti\u0006$X\rF\u0002[\u0003\u007fAq!!\u0011\u000f\u0001\u0004\t\u0019%\u0001\u0006m_\u000e\fGNR5mKN\u0004R!a\u0005\u0002\u001eI\f\u0011d\u0019:fCR,7K\\1qg\"|GOR5mK6\u000b\u0007\u000f]5oORA\u0011\u0011JA,\u00033\ni\u0006E\u0003#\u0003V\nY\u0005E\u0004\u0002N\u0005=S'!\u0015\u000e\u0003EJ!\u0001N\u0019\u0011\u0007)\n\u0019&C\u0002\u0002VE\u00111CU8dWN$%i\u00158baNDw\u000e\u001e$jY\u0016DQ!Z\bA\u0002\u0019Da!a\u0017\u0010\u0001\u0004\u0011\u0018!D2iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0003\u0004\u00024=\u0001\ra\u0011")
public class RocksDBFileMapping {
    private final scala.collection.mutable.Map<String, Tuple2<Object, RocksDBImmutableFile>> localFileMappings = (scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Set<RocksDBVersionSnapshotInfo> snapshotsPendingUpload = ConcurrentHashMap.newKeySet();

    private scala.collection.mutable.Map<String, Tuple2<Object, RocksDBImmutableFile>> localFileMappings() {
        return this.localFileMappings;
    }

    public Set<RocksDBVersionSnapshotInfo> snapshotsPendingUpload() {
        return this.snapshotsPendingUpload;
    }

    public void clear() {
        this.localFileMappings().clear();
        this.snapshotsPendingUpload().clear();
    }

    public String toString() {
        return this.localFileMappings().toString();
    }

    public Option<RocksDBImmutableFile> getDfsFileForLoad(RocksDBFileManager fileManager, String localFileName, long versionToLoad) {
        return this.getDfsFileWithIncompatibilityCheck(fileManager, localFileName, (Function2<Object, RocksDBImmutableFile, Object>)(Function2 & Serializable)(fileVersion, x$40) -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileMapping.$anonfun$getDfsFileForLoad$1(versionToLoad, BoxesRunTime.unboxToLong((Object)fileVersion), x$40)));
    }

    private Option<RocksDBImmutableFile> getDfsFileForSave(RocksDBFileManager fileManager, File localFile, long versionToSave) {
        return this.getDfsFileWithIncompatibilityCheck(fileManager, localFile.getName(), (Function2<Object, RocksDBImmutableFile, Object>)(Function2 & Serializable)(dfsFileVersion, dfsFile) -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileMapping.$anonfun$getDfsFileForSave$1(versionToSave, localFile, BoxesRunTime.unboxToLong((Object)dfsFileVersion), dfsFile)));
    }

    private Option<RocksDBImmutableFile> getDfsFileWithIncompatibilityCheck(RocksDBFileManager fileManager, String localFileName, Function2<Object, RocksDBImmutableFile, Object> isIncompatible) {
        return (Option)this.localFileMappings().get((Object)localFileName).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long dfsFileMappedVersion = tuple2._1$mcJ$sp();
                RocksDBImmutableFile dfsFile = (RocksDBImmutableFile)tuple2._2();
                String dfsFileSuffix = fileManager.dfsFileSuffix(dfsFile);
                RocksDBVersionSnapshotInfo versionSnapshotInfo = new RocksDBVersionSnapshotInfo(dfsFileMappedVersion, dfsFileSuffix);
                if (BoxesRunTime.unboxToBoolean((Object)isIncompatible.apply((Object)BoxesRunTime.boxToLong((long)dfsFileMappedVersion), (Object)dfsFile)) || this.snapshotsPendingUpload().contains(versionSnapshotInfo)) {
                    this.remove(localFileName);
                    return None$.MODULE$;
                }
                return new Some((Object)dfsFile);
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
    }

    public Seq<Tuple2<String, Tuple2<Object, RocksDBImmutableFile>>> purgeIncompatibleMappingsForLoad(long versionToLoad) {
        Seq filesToRemove = ((IterableOnceOps)this.localFileMappings().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileMapping.$anonfun$purgeIncompatibleMappingsForLoad$1(versionToLoad, x0$1)))).toSeq();
        filesToRemove.foreach((Function1 & Serializable)x0$2 -> {
            RocksDBFileMapping.$anonfun$purgeIncompatibleMappingsForLoad$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
        return filesToRemove;
    }

    public void mapToDfsFile(String localFileName, RocksDBImmutableFile dfsFile, long version) {
        this.localFileMappings().put((Object)localFileName, (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)dfsFile));
    }

    public void remove(String localFileName) {
        this.localFileMappings().remove((Object)localFileName);
    }

    private void syncWithLocalState(Seq<File> localFiles) {
        scala.collection.immutable.Set localFileNames = ((IterableOnceOps)localFiles.map((Function1 & Serializable)x$41 -> x$41.getName())).toSet();
        Iterable deletedFiles = (Iterable)this.localFileMappings().keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)localFileNames.contains((Object)elem)));
        deletedFiles.foreach((Function1 & Serializable)key -> this.localFileMappings().remove(key));
    }

    public Tuple2<String, Map<String, RocksDBSnapshotFile>> createSnapshotFileMapping(RocksDBFileManager fileManager, File checkpointDir, long version) {
        Tuple2<Seq<File>, Seq<File>> tuple2 = fileManager.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localImmutableFiles2 = localImmutableFiles;
        String dfsFilesSuffix = UUID.randomUUID().toString();
        scala.collection.immutable.Map snapshotFileMapping = ((IterableOnceOps)localImmutableFiles2.map((Function1 & Serializable)f -> {
            String localFileName = f.getName();
            Option<RocksDBImmutableFile> existingDfsFile = this.getDfsFileForSave(fileManager, (File)f, version);
            RocksDBImmutableFile dfsFile = (RocksDBImmutableFile)existingDfsFile.getOrElse((Function0 & Serializable)() -> {
                String newDfsFileName = fileManager.newDFSFileName(localFileName, dfsFilesSuffix);
                RocksDBImmutableFile newDfsFile = RocksDBImmutableFile$.MODULE$.apply(localFileName, newDfsFileName, f.length());
                this.mapToDfsFile(localFileName, newDfsFile, version);
                return newDfsFile;
            });
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)localFileName), (Object)new RocksDBSnapshotFile(dfsFile, existingDfsFile.isDefined()));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.syncWithLocalState((Seq<File>)localImmutableFiles2);
        RocksDBVersionSnapshotInfo rocksDBSnapshotInfo = new RocksDBVersionSnapshotInfo(version, dfsFilesSuffix);
        this.snapshotsPendingUpload().add(rocksDBSnapshotInfo);
        return new Tuple2((Object)dfsFilesSuffix, (Object)snapshotFileMapping);
    }

    public static final /* synthetic */ boolean $anonfun$getDfsFileForLoad$1(long versionToLoad$1, long fileVersion, RocksDBImmutableFile x$40) {
        return fileVersion >= versionToLoad$1;
    }

    public static final /* synthetic */ boolean $anonfun$getDfsFileForSave$1(long versionToSave$1, File localFile$1, long dfsFileVersion, RocksDBImmutableFile dfsFile) {
        return dfsFileVersion >= versionToSave$1 || dfsFile.sizeBytes() != localFile$1.length();
    }

    public static final /* synthetic */ boolean $anonfun$purgeIncompatibleMappingsForLoad$1(long versionToLoad$2, Tuple2 x0$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            long dfsFileMappedVersion = tuple2._1$mcJ$sp();
            return dfsFileMappedVersion >= versionToLoad$2;
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ void $anonfun$purgeIncompatibleMappingsForLoad$2(RocksDBFileMapping $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String localFileName = (String)tuple2._1();
            $this.remove(localFileName);
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

