/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;

public final class LogisticRegressionWithElasticNetExample$ {
    public static final LogisticRegressionWithElasticNetExample$ MODULE$ = new LogisticRegressionWithElasticNetExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("LogisticRegressionWithElasticNetExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        Predef$.MODULE$.println((Object)("Coefficients: " + lrModel.coefficients() + " Intercept: " + lrModel.intercept()));
        LogisticRegression mlr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8).setFamily("multinomial");
        LogisticRegressionModel mlrModel = (LogisticRegressionModel)mlr.fit(training);
        Predef$.MODULE$.println((Object)("Multinomial coefficients: " + mlrModel.coefficientMatrix()));
        Predef$.MODULE$.println((Object)("Multinomial intercepts: " + mlrModel.interceptVector()));
        spark.stop();
    }

    private LogisticRegressionWithElasticNetExample$() {
    }
}

