// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// automatically generated by the FlatBuffers compiler, do not modify
// swiftlint:disable all
// swiftformat:disable all

import FlatBuffers
import Common

/// @nodoc
public enum org_apache_arrow_flatbuf_MetadataVersion: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  ///  0.1.0 (October 2016).
  case v1 = 0
  ///  0.2.0 (February 2017). Non-backwards compatible with V1.
  case v2 = 1
  ///  0.3.0 -> 0.7.1 (May - December 2017). Non-backwards compatible with V2.
  case v3 = 2
  ///  >= 0.8.0 (December 2017). Non-backwards compatible with V3.
  case v4 = 3
  ///  >= 1.0.0 (July 2020. Backwards compatible with V4 (V5 readers can read V4
  ///  metadata and IPC messages). Implementations are recommended to provide a
  ///  V4 compatibility mode with V5 format changes disabled.
  ///
  ///  Incompatible changes between V4 and V5:
  ///  - Union buffer layout has changed. In V5, Unions don't have a validity
  ///    bitmap buffer.
  case v5 = 4

  public static var max: org_apache_arrow_flatbuf_MetadataVersion { return .v5 }
  public static var min: org_apache_arrow_flatbuf_MetadataVersion { return .v1 }
}

///  Represents Arrow Features that might not have full support
///  within implementations. This is intended to be used in
///  two scenarios:
///   1.  A mechanism for readers of Arrow Streams
///       and files to understand that the stream or file makes
///       use of a feature that isn't supported or unknown to
///       the implementation (and therefore can meet the Arrow
///       forward compatibility guarantees).
///   2.  A means of negotiating between a client and server
///       what features a stream is allowed to use. The enums
///       values here are intented to represent higher level
///       features, additional details maybe negotiated
///       with key-value pairs specific to the protocol.
///
///  Enums added to this list should be assigned power-of-two values
///  to facilitate exchanging and comparing bitmaps for supported
///  features.
/// @nodoc
public enum org_apache_arrow_flatbuf_Feature: Int64, Enum, Verifiable {
  public typealias T = Int64
  public static var byteSize: Int { return MemoryLayout<Int64>.size }
  public var value: Int64 { return self.rawValue }
  ///  Needed to make flatbuffers happy.
  case unused = 0
  ///  The stream makes use of multiple full dictionaries with the
  ///  same ID and assumes clients implement dictionary replacement
  ///  correctly.
  case dictionaryReplacement = 1
  ///  The stream makes use of compressed bodies as described
  ///  in Message.fbs.
  case compressedBody = 2

  public static var max: org_apache_arrow_flatbuf_Feature { return .compressedBody }
  public static var min: org_apache_arrow_flatbuf_Feature { return .unused }
}

/// @nodoc
public enum org_apache_arrow_flatbuf_UnionMode: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  case sparse = 0
  case dense = 1

  public static var max: org_apache_arrow_flatbuf_UnionMode { return .dense }
  public static var min: org_apache_arrow_flatbuf_UnionMode { return .sparse }
}

/// @nodoc
public enum org_apache_arrow_flatbuf_Precision: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  case half = 0
  case single = 1
  case double = 2

  public static var max: org_apache_arrow_flatbuf_Precision { return .double }
  public static var min: org_apache_arrow_flatbuf_Precision { return .half }
}

/// @nodoc
public enum org_apache_arrow_flatbuf_DateUnit: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  case day = 0
  case millisecond = 1

  public static var max: org_apache_arrow_flatbuf_DateUnit { return .millisecond }
  public static var min: org_apache_arrow_flatbuf_DateUnit { return .day }
}

/// @nodoc
public enum org_apache_arrow_flatbuf_TimeUnit: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  case second = 0
  case millisecond = 1
  case microsecond = 2
  case nanosecond = 3

  public static var max: org_apache_arrow_flatbuf_TimeUnit { return .nanosecond }
  public static var min: org_apache_arrow_flatbuf_TimeUnit { return .second }
}

/// @nodoc
public enum org_apache_arrow_flatbuf_IntervalUnit: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  case yearMonth = 0
  case dayTime = 1
  case monthDayNano = 2

  public static var max: org_apache_arrow_flatbuf_IntervalUnit { return .monthDayNano }
  public static var min: org_apache_arrow_flatbuf_IntervalUnit { return .yearMonth }
}

///  ----------------------------------------------------------------------
///  Top-level Type value, enabling extensible type-specific metadata. We can
///  add new logical types to Type without breaking backwards compatibility
/// @nodoc
public enum org_apache_arrow_flatbuf_Type_: UInt8, UnionEnum {
  public typealias T = UInt8

  public init?(value: T) {
    self.init(rawValue: value)
  }

  public static var byteSize: Int { return MemoryLayout<UInt8>.size }
  public var value: UInt8 { return self.rawValue }
  case none_ = 0
  case null = 1
  case int = 2
  case floatingpoint = 3
  case binary = 4
  case utf8 = 5
  case bool = 6
  case decimal = 7
  case date = 8
  case time = 9
  case timestamp = 10
  case interval = 11
  case list = 12
  case struct_ = 13
  case union = 14
  case fixedsizebinary = 15
  case fixedsizelist = 16
  case map = 17
  case duration = 18
  case largebinary = 19
  case largeutf8 = 20
  case largelist = 21
  case runendencoded = 22

  public static var max: org_apache_arrow_flatbuf_Type_ { return .runendencoded }
  public static var min: org_apache_arrow_flatbuf_Type_ { return .none_ }
}

///  ----------------------------------------------------------------------
///  Dictionary encoding metadata
///  Maintained for forwards compatibility, in the future
///  Dictionaries might be explicit maps between integers and values
///  allowing for non-contiguous index values
/// @nodoc
public enum org_apache_arrow_flatbuf_DictionaryKind: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  case densearray = 0

  public static var max: org_apache_arrow_flatbuf_DictionaryKind { return .densearray }
  public static var min: org_apache_arrow_flatbuf_DictionaryKind { return .densearray }
}

///  ----------------------------------------------------------------------
///  Endianness of the platform producing the data
/// @nodoc
public enum org_apache_arrow_flatbuf_Endianness: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  case little = 0
  case big = 1

  public static var max: org_apache_arrow_flatbuf_Endianness { return .big }
  public static var min: org_apache_arrow_flatbuf_Endianness { return .little }
}

///  ----------------------------------------------------------------------
///  A Buffer represents a single contiguous memory segment
/// @nodoc
public struct org_apache_arrow_flatbuf_Buffer: NativeStruct, Verifiable, FlatbuffersInitializable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }

  ///  The relative offset into the shared memory page where the bytes for this
  ///  buffer starts
  private var _offset: Int64
  ///  The absolute length (in bytes) of the memory buffer. The memory is found
  ///  from offset (inclusive) to offset + length (non-inclusive). When building
  ///  messages using the encapsulated IPC message, padding bytes may be written
  ///  after a buffer, but such padding bytes do not need to be accounted for in
  ///  the size here.
  private var _length: Int64

  public init(_ bb: ByteBuffer, o: Int32) {
    let _accessor = Struct(bb: bb, position: o)
    _offset = _accessor.readBuffer(of: Int64.self, at: 0)
    _length = _accessor.readBuffer(of: Int64.self, at: 8)
  }

  public init(offset: Int64, length: Int64) {
    _offset = offset
    _length = length
  }

  public init() {
    _offset = 0
    _length = 0
  }

  ///  The relative offset into the shared memory page where the bytes for this
  ///  buffer starts
  public var offset: Int64 { _offset }
  ///  The absolute length (in bytes) of the memory buffer. The memory is found
  ///  from offset (inclusive) to offset + length (non-inclusive). When building
  ///  messages using the encapsulated IPC message, padding bytes may be written
  ///  after a buffer, but such padding bytes do not need to be accounted for in
  ///  the size here.
  public var length: Int64 { _length }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    try verifier.inBuffer(position: position, of: org_apache_arrow_flatbuf_Buffer.self)
  }
}

///  ----------------------------------------------------------------------
///  A Buffer represents a single contiguous memory segment
/// @nodoc
public struct org_apache_arrow_flatbuf_Buffer_Mutable: FlatBufferStruct {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Struct

  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Struct(bb: bb, position: o) }

  public var offset: Int64 { return _accessor.readBuffer(of: Int64.self, at: 0) }
  public var length: Int64 { return _accessor.readBuffer(of: Int64.self, at: 8) }
}

///  These are stored in the flatbuffer in the Type union below
/// @nodoc
public struct org_apache_arrow_flatbuf_Null: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsNull(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Null {
    return org_apache_arrow_flatbuf_Null(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startNull(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endNull(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

///  A Struct_ in the flatbuffer metadata is the same as an Arrow Struct
///  (according to the physical memory layout). We used Struct_ here as
///  Struct is a reserved word in Flatbuffers
/// @nodoc
public struct org_apache_arrow_flatbuf_Struct_: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsStruct_(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Struct_ {
    return org_apache_arrow_flatbuf_Struct_(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startStruct_(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endStruct_(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_List: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsList(bb: ByteBuffer) -> org_apache_arrow_flatbuf_List {
    return org_apache_arrow_flatbuf_List(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startList(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endList(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

///  Same as List, but with 64-bit offsets, allowing to represent
///  extremely large data values.
/// @nodoc
public struct org_apache_arrow_flatbuf_LargeList: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsLargeList(bb: ByteBuffer) -> org_apache_arrow_flatbuf_LargeList {
    return org_apache_arrow_flatbuf_LargeList(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startLargeList(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endLargeList(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_FixedSizeList: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsFixedSizeList(bb: ByteBuffer)
    -> org_apache_arrow_flatbuf_FixedSizeList
  {
    return org_apache_arrow_flatbuf_FixedSizeList(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case listSize = 4
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  Number of list items per value
  public var listSize: Int32 {
    let o = _accessor.offset(VTOFFSET.listSize.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int32.self, at: o)
  }
  public static func startFixedSizeList(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 1)
  }
  public static func add(listSize: Int32, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: listSize, def: 0, at: VTOFFSET.listSize.p)
  }
  public static func endFixedSizeList(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createFixedSizeList(
    _ fbb: inout FlatBufferBuilder,
    listSize: Int32 = 0
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_FixedSizeList.startFixedSizeList(&fbb)
    org_apache_arrow_flatbuf_FixedSizeList.add(listSize: listSize, &fbb)
    return org_apache_arrow_flatbuf_FixedSizeList.endFixedSizeList(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.listSize.p, fieldName: "listSize", required: false, type: Int32.self)
    _v.finish()
  }
}

///  A Map is a logical nested type that is represented as
///
///  List<entries: Struct<key: K, value: V>>
///
///  In this layout, the keys and values are each respectively contiguous. We do
///  not constrain the key and value types, so the application is responsible
///  for ensuring that the keys are hashable and unique. Whether the keys are sorted
///  may be set in the metadata for this field.
///
///  In a field with Map type, the field has a child Struct field, which then
///  has two children: key type and the second the value type. The names of the
///  child fields may be respectively "entries", "key", and "value", but this is
///  not enforced.
///
///  Map
///  ```text
///    - child[0] entries: Struct
///      - child[0] key: K
///      - child[1] value: V
///  ```
///  Neither the "entries" field nor the "key" field may be nullable.
///
///  The metadata is structured so that Arrow systems without special handling
///  for Map can make Map an alias for List. The "layout" attribute for the Map
///  field must have the same contents as a List.
/// @nodoc
public struct org_apache_arrow_flatbuf_Map: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsMap(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Map {
    return org_apache_arrow_flatbuf_Map(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case keysSorted = 4
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  Set to true if the keys within each value are sorted
  public var keysSorted: Bool {
    let o = _accessor.offset(VTOFFSET.keysSorted.v)
    return o == 0 ? false : 0 != _accessor.readBuffer(of: Byte.self, at: o)
  }
  public static func startMap(_ fbb: inout FlatBufferBuilder) -> UOffset { fbb.startTable(with: 1) }
  public static func add(keysSorted: Bool, _ fbb: inout FlatBufferBuilder) {
    fbb.add(
      element: keysSorted, def: false,
      at: VTOFFSET.keysSorted.p)
  }
  public static func endMap(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createMap(
    _ fbb: inout FlatBufferBuilder,
    keysSorted: Bool = false
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Map.startMap(&fbb)
    org_apache_arrow_flatbuf_Map.add(keysSorted: keysSorted, &fbb)
    return org_apache_arrow_flatbuf_Map.endMap(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.keysSorted.p, fieldName: "keysSorted", required: false, type: Bool.self)
    _v.finish()
  }
}

///  A union is a complex type with children in Field
///  By default ids in the type vector refer to the offsets in the children
///  optionally typeIds provides an indirection between the child offset and the type id
///  for each child `typeIds[offset]` is the id used in the type vector
/// @nodoc
public struct org_apache_arrow_flatbuf_Union: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsUnion(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Union {
    return org_apache_arrow_flatbuf_Union(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case mode = 4
    case typeIds = 6
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var mode: org_apache_arrow_flatbuf_UnionMode {
    let o = _accessor.offset(VTOFFSET.mode.v)
    return o == 0
      ? .sparse
      : org_apache_arrow_flatbuf_UnionMode(rawValue: _accessor.readBuffer(of: Int16.self, at: o))
        ?? .sparse
  }
  public var hasTypeIds: Bool {
    let o = _accessor.offset(VTOFFSET.typeIds.v)
    return o == 0 ? false : true
  }
  public var typeIdsCount: Int32 {
    let o = _accessor.offset(VTOFFSET.typeIds.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func typeIds(at index: Int32) -> Int32 {
    let o = _accessor.offset(VTOFFSET.typeIds.v)
    return o == 0
      ? 0 : _accessor.bb.read(def: Int32.self, position: Int(_accessor.vector(at: o) + index * 4))
  }
  public var typeIds: [Int32] { return _accessor.getVector(at: VTOFFSET.typeIds.v) ?? [] }
  public static func startUnion(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 2)
  }
  public static func add(mode: org_apache_arrow_flatbuf_UnionMode, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: mode.rawValue, def: 0, at: VTOFFSET.mode.p)
  }
  public static func addVectorOf(typeIds: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: typeIds, at: VTOFFSET.typeIds.p)
  }
  public static func endUnion(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createUnion(
    _ fbb: inout FlatBufferBuilder,
    mode: org_apache_arrow_flatbuf_UnionMode = .sparse,
    typeIdsVectorOffset typeIds: Offset = Offset()
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Union.startUnion(&fbb)
    org_apache_arrow_flatbuf_Union.add(mode: mode, &fbb)
    org_apache_arrow_flatbuf_Union.addVectorOf(typeIds: typeIds, &fbb)
    return org_apache_arrow_flatbuf_Union.endUnion(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.mode.p, fieldName: "mode", required: false,
      type: org_apache_arrow_flatbuf_UnionMode.self)
    try _v.visit(
      field: VTOFFSET.typeIds.p, fieldName: "typeIds", required: false,
      type: ForwardOffset<Vector<Int32, Int32>>.self)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_Int: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsInt(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Int {
    return org_apache_arrow_flatbuf_Int(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case bitWidth = 4
    case isSigned = 6
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var bitWidth: Int32 {
    let o = _accessor.offset(VTOFFSET.bitWidth.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int32.self, at: o)
  }
  public var isSigned: Bool {
    let o = _accessor.offset(VTOFFSET.isSigned.v)
    return o == 0 ? false : 0 != _accessor.readBuffer(of: Byte.self, at: o)
  }
  public static func startInt(_ fbb: inout FlatBufferBuilder) -> UOffset { fbb.startTable(with: 2) }
  public static func add(bitWidth: Int32, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: bitWidth, def: 0, at: VTOFFSET.bitWidth.p)
  }
  public static func add(isSigned: Bool, _ fbb: inout FlatBufferBuilder) {
    fbb.add(
      element: isSigned, def: false,
      at: VTOFFSET.isSigned.p)
  }
  public static func endInt(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createInt(
    _ fbb: inout FlatBufferBuilder,
    bitWidth: Int32 = 0,
    isSigned: Bool = false
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Int.startInt(&fbb)
    org_apache_arrow_flatbuf_Int.add(bitWidth: bitWidth, &fbb)
    org_apache_arrow_flatbuf_Int.add(isSigned: isSigned, &fbb)
    return org_apache_arrow_flatbuf_Int.endInt(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.bitWidth.p, fieldName: "bitWidth", required: false, type: Int32.self)
    try _v.visit(
      field: VTOFFSET.isSigned.p, fieldName: "isSigned", required: false, type: Bool.self)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_FloatingPoint: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsFloatingPoint(bb: ByteBuffer)
    -> org_apache_arrow_flatbuf_FloatingPoint
  {
    return org_apache_arrow_flatbuf_FloatingPoint(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case precision = 4
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var precision: org_apache_arrow_flatbuf_Precision {
    let o = _accessor.offset(VTOFFSET.precision.v)
    return o == 0
      ? .half
      : org_apache_arrow_flatbuf_Precision(rawValue: _accessor.readBuffer(of: Int16.self, at: o))
        ?? .half
  }
  public static func startFloatingPoint(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 1)
  }
  public static func add(
    precision: org_apache_arrow_flatbuf_Precision, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: precision.rawValue, def: 0, at: VTOFFSET.precision.p) }
  public static func endFloatingPoint(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createFloatingPoint(
    _ fbb: inout FlatBufferBuilder,
    precision: org_apache_arrow_flatbuf_Precision = .half
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_FloatingPoint.startFloatingPoint(&fbb)
    org_apache_arrow_flatbuf_FloatingPoint.add(precision: precision, &fbb)
    return org_apache_arrow_flatbuf_FloatingPoint.endFloatingPoint(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.precision.p, fieldName: "precision", required: false,
      type: org_apache_arrow_flatbuf_Precision.self)
    _v.finish()
  }
}

///  Unicode with UTF-8 encoding
/// @nodoc
public struct org_apache_arrow_flatbuf_Utf8: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsUtf8(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Utf8 {
    return org_apache_arrow_flatbuf_Utf8(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startUtf8(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endUtf8(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

///  Opaque binary data
/// @nodoc
public struct org_apache_arrow_flatbuf_Binary: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsBinary(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Binary {
    return org_apache_arrow_flatbuf_Binary(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startBinary(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endBinary(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

///  Same as Utf8, but with 64-bit offsets, allowing to represent
///  extremely large data values.
/// @nodoc
public struct org_apache_arrow_flatbuf_LargeUtf8: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsLargeUtf8(bb: ByteBuffer) -> org_apache_arrow_flatbuf_LargeUtf8 {
    return org_apache_arrow_flatbuf_LargeUtf8(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startLargeUtf8(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endLargeUtf8(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

///  Same as Binary, but with 64-bit offsets, allowing to represent
///  extremely large data values.
/// @nodoc
public struct org_apache_arrow_flatbuf_LargeBinary: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsLargeBinary(bb: ByteBuffer) -> org_apache_arrow_flatbuf_LargeBinary {
    return org_apache_arrow_flatbuf_LargeBinary(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startLargeBinary(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endLargeBinary(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_FixedSizeBinary: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsFixedSizeBinary(bb: ByteBuffer)
    -> org_apache_arrow_flatbuf_FixedSizeBinary
  {
    return org_apache_arrow_flatbuf_FixedSizeBinary(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case byteWidth = 4
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  Number of bytes per value
  public var byteWidth: Int32 {
    let o = _accessor.offset(VTOFFSET.byteWidth.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int32.self, at: o)
  }
  public static func startFixedSizeBinary(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 1)
  }
  public static func add(byteWidth: Int32, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: byteWidth, def: 0, at: VTOFFSET.byteWidth.p)
  }
  public static func endFixedSizeBinary(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createFixedSizeBinary(
    _ fbb: inout FlatBufferBuilder,
    byteWidth: Int32 = 0
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_FixedSizeBinary.startFixedSizeBinary(&fbb)
    org_apache_arrow_flatbuf_FixedSizeBinary.add(byteWidth: byteWidth, &fbb)
    return org_apache_arrow_flatbuf_FixedSizeBinary.endFixedSizeBinary(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.byteWidth.p, fieldName: "byteWidth", required: false, type: Int32.self)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_Bool: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsBool(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Bool {
    return org_apache_arrow_flatbuf_Bool(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startBool(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endBool(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

///  Contains two child arrays, run_ends and values.
///  The run_ends child array must be a 16/32/64-bit integer array
///  which encodes the indices at which the run with the value in
///  each corresponding index in the values child array ends.
///  Like list/struct types, the value array can be of any type.
/// @nodoc
public struct org_apache_arrow_flatbuf_RunEndEncoded: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsRunEndEncoded(bb: ByteBuffer)
    -> org_apache_arrow_flatbuf_RunEndEncoded
  {
    return org_apache_arrow_flatbuf_RunEndEncoded(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  public static func startRunEndEncoded(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 0)
  }
  public static func endRunEndEncoded(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    _v.finish()
  }
}

///  Exact decimal value represented as an integer value in two's
///  complement. Currently only 128-bit (16-byte) and 256-bit (32-byte) integers
///  are used. The representation uses the endianness indicated
///  in the Schema.
/// @nodoc
public struct org_apache_arrow_flatbuf_Decimal: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsDecimal(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Decimal {
    return org_apache_arrow_flatbuf_Decimal(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case precision = 4
    case scale = 6
    case bitWidth = 8
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  Total number of decimal digits
  public var precision: Int32 {
    let o = _accessor.offset(VTOFFSET.precision.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int32.self, at: o)
  }
  ///  Number of digits after the decimal point "."
  public var scale: Int32 {
    let o = _accessor.offset(VTOFFSET.scale.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int32.self, at: o)
  }
  ///  Number of bits per value. The only accepted widths are 128 and 256.
  ///  We use bitWidth for consistency with Int::bitWidth.
  public var bitWidth: Int32 {
    let o = _accessor.offset(VTOFFSET.bitWidth.v)
    return o == 0 ? 128 : _accessor.readBuffer(of: Int32.self, at: o)
  }
  public static func startDecimal(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 3)
  }
  public static func add(precision: Int32, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: precision, def: 0, at: VTOFFSET.precision.p)
  }
  public static func add(scale: Int32, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: scale, def: 0, at: VTOFFSET.scale.p)
  }
  public static func add(bitWidth: Int32, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: bitWidth, def: 128, at: VTOFFSET.bitWidth.p)
  }
  public static func endDecimal(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createDecimal(
    _ fbb: inout FlatBufferBuilder,
    precision: Int32 = 0,
    scale: Int32 = 0,
    bitWidth: Int32 = 128
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Decimal.startDecimal(&fbb)
    org_apache_arrow_flatbuf_Decimal.add(precision: precision, &fbb)
    org_apache_arrow_flatbuf_Decimal.add(scale: scale, &fbb)
    org_apache_arrow_flatbuf_Decimal.add(bitWidth: bitWidth, &fbb)
    return org_apache_arrow_flatbuf_Decimal.endDecimal(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.precision.p, fieldName: "precision", required: false, type: Int32.self)
    try _v.visit(field: VTOFFSET.scale.p, fieldName: "scale", required: false, type: Int32.self)
    try _v.visit(
      field: VTOFFSET.bitWidth.p, fieldName: "bitWidth", required: false, type: Int32.self)
    _v.finish()
  }
}

///  Date is either a 32-bit or 64-bit signed integer type representing an
///  elapsed time since UNIX epoch (1970-01-01), stored in either of two units:
///
///  * Milliseconds (64 bits) indicating UNIX time elapsed since the epoch (no
///    leap seconds), where the values are evenly divisible by 86400000
///  * Days (32 bits) since the UNIX epoch
/// @nodoc
public struct org_apache_arrow_flatbuf_Date: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsDate(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Date {
    return org_apache_arrow_flatbuf_Date(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case unit = 4
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var unit: org_apache_arrow_flatbuf_DateUnit {
    let o = _accessor.offset(VTOFFSET.unit.v)
    return o == 0
      ? .millisecond
      : org_apache_arrow_flatbuf_DateUnit(rawValue: _accessor.readBuffer(of: Int16.self, at: o))
        ?? .millisecond
  }
  public static func startDate(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 1)
  }
  public static func add(unit: org_apache_arrow_flatbuf_DateUnit, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: unit.rawValue, def: 1, at: VTOFFSET.unit.p)
  }
  public static func endDate(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createDate(
    _ fbb: inout FlatBufferBuilder,
    unit: org_apache_arrow_flatbuf_DateUnit = .millisecond
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Date.startDate(&fbb)
    org_apache_arrow_flatbuf_Date.add(unit: unit, &fbb)
    return org_apache_arrow_flatbuf_Date.endDate(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.unit.p, fieldName: "unit", required: false,
      type: org_apache_arrow_flatbuf_DateUnit.self)
    _v.finish()
  }
}

///  Time is either a 32-bit or 64-bit signed integer type representing an
///  elapsed time since midnight, stored in either of four units: seconds,
///  milliseconds, microseconds or nanoseconds.
///
///  The integer `bitWidth` depends on the `unit` and must be one of the following:
///  * SECOND and MILLISECOND: 32 bits
///  * MICROSECOND and NANOSECOND: 64 bits
///
///  The allowed values are between 0 (inclusive) and 86400 (=24*60*60) seconds
///  (exclusive), adjusted for the time unit (for example, up to 86400000
///  exclusive for the MILLISECOND unit).
///  This definition doesn't allow for leap seconds. Time values from
///  measurements with leap seconds will need to be corrected when ingesting
///  into Arrow (for example by replacing the value 86400 with 86399).
/// @nodoc
public struct org_apache_arrow_flatbuf_Time: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsTime(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Time {
    return org_apache_arrow_flatbuf_Time(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case unit = 4
    case bitWidth = 6
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var unit: org_apache_arrow_flatbuf_TimeUnit {
    let o = _accessor.offset(VTOFFSET.unit.v)
    return o == 0
      ? .millisecond
      : org_apache_arrow_flatbuf_TimeUnit(rawValue: _accessor.readBuffer(of: Int16.self, at: o))
        ?? .millisecond
  }
  public var bitWidth: Int32 {
    let o = _accessor.offset(VTOFFSET.bitWidth.v)
    return o == 0 ? 32 : _accessor.readBuffer(of: Int32.self, at: o)
  }
  public static func startTime(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 2)
  }
  public static func add(unit: org_apache_arrow_flatbuf_TimeUnit, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: unit.rawValue, def: 1, at: VTOFFSET.unit.p)
  }
  public static func add(bitWidth: Int32, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: bitWidth, def: 32, at: VTOFFSET.bitWidth.p)
  }
  public static func endTime(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createTime(
    _ fbb: inout FlatBufferBuilder,
    unit: org_apache_arrow_flatbuf_TimeUnit = .millisecond,
    bitWidth: Int32 = 32
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Time.startTime(&fbb)
    org_apache_arrow_flatbuf_Time.add(unit: unit, &fbb)
    org_apache_arrow_flatbuf_Time.add(bitWidth: bitWidth, &fbb)
    return org_apache_arrow_flatbuf_Time.endTime(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.unit.p, fieldName: "unit", required: false,
      type: org_apache_arrow_flatbuf_TimeUnit.self)
    try _v.visit(
      field: VTOFFSET.bitWidth.p, fieldName: "bitWidth", required: false, type: Int32.self)
    _v.finish()
  }
}

///  Timestamp is a 64-bit signed integer representing an elapsed time since a
///  fixed epoch, stored in either of four units: seconds, milliseconds,
///  microseconds or nanoseconds, and is optionally annotated with a timezone.
///
///  Timestamp values do not include any leap seconds (in other words, all
///  days are considered 86400 seconds long).
///
///  Timestamps with a non-empty timezone
///  ------------------------------------
///
///  If a Timestamp column has a non-empty timezone value, its epoch is
///  1970-01-01 00:00:00 (January 1st 1970, midnight) in the *UTC* timezone
///  (the Unix epoch), regardless of the Timestamp's own timezone.
///
///  Therefore, timestamp values with a non-empty timezone correspond to
///  physical points in time together with some additional information about
///  how the data was obtained and/or how to display it (the timezone).
///
///    For example, the timestamp value 0 with the timezone string "Europe/Paris"
///    corresponds to "January 1st 1970, 00h00" in the UTC timezone, but the
///    application may prefer to display it as "January 1st 1970, 01h00" in
///    the Europe/Paris timezone (which is the same physical point in time).
///
///  One consequence is that timestamp values with a non-empty timezone
///  can be compared and ordered directly, since they all share the same
///  well-known point of reference (the Unix epoch).
///
///  Timestamps with an unset / empty timezone
///  -----------------------------------------
///
///  If a Timestamp column has no timezone value, its epoch is
///  1970-01-01 00:00:00 (January 1st 1970, midnight) in an *unknown* timezone.
///
///  Therefore, timestamp values without a timezone cannot be meaningfully
///  interpreted as physical points in time, but only as calendar / clock
///  indications ("wall clock time") in an unspecified timezone.
///
///    For example, the timestamp value 0 with an empty timezone string
///    corresponds to "January 1st 1970, 00h00" in an unknown timezone: there
///    is not enough information to interpret it as a well-defined physical
///    point in time.
///
///  One consequence is that timestamp values without a timezone cannot
///  be reliably compared or ordered, since they may have different points of
///  reference.  In particular, it is *not* possible to interpret an unset
///  or empty timezone as the same as "UTC".
///
///  Conversion between timezones
///  ----------------------------
///
///  If a Timestamp column has a non-empty timezone, changing the timezone
///  to a different non-empty value is a metadata-only operation:
///  the timestamp values need not change as their point of reference remains
///  the same (the Unix epoch).
///
///  However, if a Timestamp column has no timezone value, changing it to a
///  non-empty value requires to think about the desired semantics.
///  One possibility is to assume that the original timestamp values are
///  relative to the epoch of the timezone being set; timestamp values should
///  then adjusted to the Unix epoch (for example, changing the timezone from
///  empty to "Europe/Paris" would require converting the timestamp values
///  from "Europe/Paris" to "UTC", which seems counter-intuitive but is
///  nevertheless correct).
///
///  Guidelines for encoding data from external libraries
///  ----------------------------------------------------
///
///  Date & time libraries often have multiple different data types for temporal
///  data. In order to ease interoperability between different implementations the
///  Arrow project has some recommendations for encoding these types into a Timestamp
///  column.
///
///  An "instant" represents a physical point in time that has no relevant timezone
///  (for example, astronomical data). To encode an instant, use a Timestamp with
///  the timezone string set to "UTC", and make sure the Timestamp values
///  are relative to the UTC epoch (January 1st 1970, midnight).
///
///  A "zoned date-time" represents a physical point in time annotated with an
///  informative timezone (for example, the timezone in which the data was
///  recorded).  To encode a zoned date-time, use a Timestamp with the timezone
///  string set to the name of the timezone, and make sure the Timestamp values
///  are relative to the UTC epoch (January 1st 1970, midnight).
///
///   (There is some ambiguity between an instant and a zoned date-time with the
///    UTC timezone.  Both of these are stored the same in Arrow.  Typically,
///    this distinction does not matter.  If it does, then an application should
///    use custom metadata or an extension type to distinguish between the two cases.)
///
///  An "offset date-time" represents a physical point in time combined with an
///  explicit offset from UTC.  To encode an offset date-time, use a Timestamp
///  with the timezone string set to the numeric timezone offset string
///  (e.g. "+03:00"), and make sure the Timestamp values are relative to
///  the UTC epoch (January 1st 1970, midnight).
///
///  A "naive date-time" (also called "local date-time" in some libraries)
///  represents a wall clock time combined with a calendar date, but with
///  no indication of how to map this information to a physical point in time.
///  Naive date-times must be handled with care because of this missing
///  information, and also because daylight saving time (DST) may make
///  some values ambiguous or nonexistent. A naive date-time may be
///  stored as a struct with Date and Time fields. However, it may also be
///  encoded into a Timestamp column with an empty timezone. The timestamp
///  values should be computed "as if" the timezone of the date-time values
///  was UTC; for example, the naive date-time "January 1st 1970, 00h00" would
///  be encoded as timestamp value 0.
/// @nodoc
public struct org_apache_arrow_flatbuf_Timestamp: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsTimestamp(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Timestamp {
    return org_apache_arrow_flatbuf_Timestamp(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case unit = 4
    case timezone = 6
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var unit: org_apache_arrow_flatbuf_TimeUnit {
    let o = _accessor.offset(VTOFFSET.unit.v)
    return o == 0
      ? .second
      : org_apache_arrow_flatbuf_TimeUnit(rawValue: _accessor.readBuffer(of: Int16.self, at: o))
        ?? .second
  }
  ///  The timezone is an optional string indicating the name of a timezone,
  ///  one of:
  ///
  ///  * As used in the Olson timezone database (the "tz database" or
  ///    "tzdata"), such as "America/New_York".
  ///  * An absolute timezone offset of the form "+XX:XX" or "-XX:XX",
  ///    such as "+07:30".
  ///
  ///  Whether a timezone string is present indicates different semantics about
  ///  the data (see above).
  public var timezone: String? {
    let o = _accessor.offset(VTOFFSET.timezone.v)
    return o == 0 ? nil : _accessor.string(at: o)
  }
  public var timezoneSegmentArray: [UInt8]? { return _accessor.getVector(at: VTOFFSET.timezone.v) }
  public static func startTimestamp(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 2)
  }
  public static func add(unit: org_apache_arrow_flatbuf_TimeUnit, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: unit.rawValue, def: 0, at: VTOFFSET.unit.p)
  }
  public static func add(timezone: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: timezone, at: VTOFFSET.timezone.p)
  }
  public static func endTimestamp(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createTimestamp(
    _ fbb: inout FlatBufferBuilder,
    unit: org_apache_arrow_flatbuf_TimeUnit = .second,
    timezoneOffset timezone: Offset = Offset()
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Timestamp.startTimestamp(&fbb)
    org_apache_arrow_flatbuf_Timestamp.add(unit: unit, &fbb)
    org_apache_arrow_flatbuf_Timestamp.add(timezone: timezone, &fbb)
    return org_apache_arrow_flatbuf_Timestamp.endTimestamp(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.unit.p, fieldName: "unit", required: false,
      type: org_apache_arrow_flatbuf_TimeUnit.self)
    try _v.visit(
      field: VTOFFSET.timezone.p, fieldName: "timezone", required: false,
      type: ForwardOffset<String>.self)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_Interval: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsInterval(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Interval {
    return org_apache_arrow_flatbuf_Interval(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case unit = 4
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var unit: org_apache_arrow_flatbuf_IntervalUnit {
    let o = _accessor.offset(VTOFFSET.unit.v)
    return o == 0
      ? .yearMonth
      : org_apache_arrow_flatbuf_IntervalUnit(rawValue: _accessor.readBuffer(of: Int16.self, at: o))
        ?? .yearMonth
  }
  public static func startInterval(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 1)
  }
  public static func add(
    unit: org_apache_arrow_flatbuf_IntervalUnit, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: unit.rawValue, def: 0, at: VTOFFSET.unit.p) }
  public static func endInterval(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createInterval(
    _ fbb: inout FlatBufferBuilder,
    unit: org_apache_arrow_flatbuf_IntervalUnit = .yearMonth
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Interval.startInterval(&fbb)
    org_apache_arrow_flatbuf_Interval.add(unit: unit, &fbb)
    return org_apache_arrow_flatbuf_Interval.endInterval(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.unit.p, fieldName: "unit", required: false,
      type: org_apache_arrow_flatbuf_IntervalUnit.self)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_Duration: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsDuration(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Duration {
    return org_apache_arrow_flatbuf_Duration(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case unit = 4
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var unit: org_apache_arrow_flatbuf_TimeUnit {
    let o = _accessor.offset(VTOFFSET.unit.v)
    return o == 0
      ? .millisecond
      : org_apache_arrow_flatbuf_TimeUnit(rawValue: _accessor.readBuffer(of: Int16.self, at: o))
        ?? .millisecond
  }
  public static func startDuration(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 1)
  }
  public static func add(unit: org_apache_arrow_flatbuf_TimeUnit, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: unit.rawValue, def: 1, at: VTOFFSET.unit.p)
  }
  public static func endDuration(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createDuration(
    _ fbb: inout FlatBufferBuilder,
    unit: org_apache_arrow_flatbuf_TimeUnit = .millisecond
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Duration.startDuration(&fbb)
    org_apache_arrow_flatbuf_Duration.add(unit: unit, &fbb)
    return org_apache_arrow_flatbuf_Duration.endDuration(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.unit.p, fieldName: "unit", required: false,
      type: org_apache_arrow_flatbuf_TimeUnit.self)
    _v.finish()
  }
}

///  ----------------------------------------------------------------------
///  user defined key value pairs to add custom metadata to arrow
///  key namespacing is the responsibility of the user
/// @nodoc
public struct org_apache_arrow_flatbuf_KeyValue: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsKeyValue(bb: ByteBuffer) -> org_apache_arrow_flatbuf_KeyValue {
    return org_apache_arrow_flatbuf_KeyValue(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case key = 4
    case value = 6
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var key: String? {
    let o = _accessor.offset(VTOFFSET.key.v)
    return o == 0 ? nil : _accessor.string(at: o)
  }
  public var keySegmentArray: [UInt8]? { return _accessor.getVector(at: VTOFFSET.key.v) }
  public var value: String? {
    let o = _accessor.offset(VTOFFSET.value.v)
    return o == 0 ? nil : _accessor.string(at: o)
  }
  public var valueSegmentArray: [UInt8]? { return _accessor.getVector(at: VTOFFSET.value.v) }
  public static func startKeyValue(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 2)
  }
  public static func add(key: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: key, at: VTOFFSET.key.p)
  }
  public static func add(value: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: value, at: VTOFFSET.value.p)
  }
  public static func endKeyValue(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createKeyValue(
    _ fbb: inout FlatBufferBuilder,
    keyOffset key: Offset = Offset(),
    valueOffset value: Offset = Offset()
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_KeyValue.startKeyValue(&fbb)
    org_apache_arrow_flatbuf_KeyValue.add(key: key, &fbb)
    org_apache_arrow_flatbuf_KeyValue.add(value: value, &fbb)
    return org_apache_arrow_flatbuf_KeyValue.endKeyValue(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.key.p, fieldName: "key", required: false, type: ForwardOffset<String>.self)
    try _v.visit(
      field: VTOFFSET.value.p, fieldName: "value", required: false, type: ForwardOffset<String>.self
    )
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_DictionaryEncoding: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsDictionaryEncoding(bb: ByteBuffer)
    -> org_apache_arrow_flatbuf_DictionaryEncoding
  {
    return org_apache_arrow_flatbuf_DictionaryEncoding(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case id = 4
    case indexType = 6
    case isOrdered = 8
    case dictionaryKind = 10
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  The known dictionary id in the application where this data is used. In
  ///  the file or streaming formats, the dictionary ids are found in the
  ///  DictionaryBatch messages
  public var id: Int64 {
    let o = _accessor.offset(VTOFFSET.id.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int64.self, at: o)
  }
  ///  The dictionary indices are constrained to be non-negative integers. If
  ///  this field is null, the indices must be signed int32. To maximize
  ///  cross-language compatibility and performance, implementations are
  ///  recommended to prefer signed integer types over unsigned integer types
  ///  and to avoid uint64 indices unless they are required by an application.
  public var indexType: org_apache_arrow_flatbuf_Int? {
    let o = _accessor.offset(VTOFFSET.indexType.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_Int(_accessor.bb, o: _accessor.indirect(o + _accessor.position))
  }
  ///  By default, dictionaries are not ordered, or the order does not have
  ///  semantic meaning. In some statistical, applications, dictionary-encoding
  ///  is used to represent ordered categorical data, and we provide a way to
  ///  preserve that metadata here
  public var isOrdered: Bool {
    let o = _accessor.offset(VTOFFSET.isOrdered.v)
    return o == 0 ? false : 0 != _accessor.readBuffer(of: Byte.self, at: o)
  }
  public var dictionaryKind: org_apache_arrow_flatbuf_DictionaryKind {
    let o = _accessor.offset(VTOFFSET.dictionaryKind.v)
    return o == 0
      ? .densearray
      : org_apache_arrow_flatbuf_DictionaryKind(
        rawValue: _accessor.readBuffer(of: Int16.self, at: o)) ?? .densearray
  }
  public static func startDictionaryEncoding(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 4)
  }
  public static func add(id: Int64, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: id, def: 0, at: VTOFFSET.id.p)
  }
  public static func add(indexType: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: indexType, at: VTOFFSET.indexType.p)
  }
  public static func add(isOrdered: Bool, _ fbb: inout FlatBufferBuilder) {
    fbb.add(
      element: isOrdered, def: false,
      at: VTOFFSET.isOrdered.p)
  }
  public static func add(
    dictionaryKind: org_apache_arrow_flatbuf_DictionaryKind, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: dictionaryKind.rawValue, def: 0, at: VTOFFSET.dictionaryKind.p) }
  public static func endDictionaryEncoding(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset
  {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createDictionaryEncoding(
    _ fbb: inout FlatBufferBuilder,
    id: Int64 = 0,
    indexTypeOffset indexType: Offset = Offset(),
    isOrdered: Bool = false,
    dictionaryKind: org_apache_arrow_flatbuf_DictionaryKind = .densearray
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_DictionaryEncoding.startDictionaryEncoding(&fbb)
    org_apache_arrow_flatbuf_DictionaryEncoding.add(id: id, &fbb)
    org_apache_arrow_flatbuf_DictionaryEncoding.add(indexType: indexType, &fbb)
    org_apache_arrow_flatbuf_DictionaryEncoding.add(isOrdered: isOrdered, &fbb)
    org_apache_arrow_flatbuf_DictionaryEncoding.add(dictionaryKind: dictionaryKind, &fbb)
    return org_apache_arrow_flatbuf_DictionaryEncoding.endDictionaryEncoding(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(field: VTOFFSET.id.p, fieldName: "id", required: false, type: Int64.self)
    try _v.visit(
      field: VTOFFSET.indexType.p, fieldName: "indexType", required: false,
      type: ForwardOffset<org_apache_arrow_flatbuf_Int>.self)
    try _v.visit(
      field: VTOFFSET.isOrdered.p, fieldName: "isOrdered", required: false, type: Bool.self)
    try _v.visit(
      field: VTOFFSET.dictionaryKind.p, fieldName: "dictionaryKind", required: false,
      type: org_apache_arrow_flatbuf_DictionaryKind.self)
    _v.finish()
  }
}

///  ----------------------------------------------------------------------
///  A field represents a named column in a record / row batch or child of a
///  nested type.
/// @nodoc
public struct org_apache_arrow_flatbuf_Field: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsField(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Field {
    return org_apache_arrow_flatbuf_Field(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case name = 4
    case nullable = 6
    case typeType = 8
    case type = 10
    case dictionary = 12
    case children = 14
    case customMetadata = 16
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  Name is not required, in i.e. a List
  public var name: String? {
    let o = _accessor.offset(VTOFFSET.name.v)
    return o == 0 ? nil : _accessor.string(at: o)
  }
  public var nameSegmentArray: [UInt8]? { return _accessor.getVector(at: VTOFFSET.name.v) }
  ///  Whether or not this field can contain nulls. Should be true in general.
  public var nullable: Bool {
    let o = _accessor.offset(VTOFFSET.nullable.v)
    return o == 0 ? false : 0 != _accessor.readBuffer(of: Byte.self, at: o)
  }
  public var typeType: org_apache_arrow_flatbuf_Type_ {
    let o = _accessor.offset(VTOFFSET.typeType.v)
    return o == 0
      ? .none_
      : org_apache_arrow_flatbuf_Type_(rawValue: _accessor.readBuffer(of: UInt8.self, at: o))
        ?? .none_
  }
  ///  This is the type of the decoded value if the field is dictionary encoded.
  public func type<T: FlatbuffersInitializable>(type: T.Type) -> T? {
    let o = _accessor.offset(VTOFFSET.type.v)
    return o == 0 ? nil : _accessor.union(o)
  }
  ///  Present only if the field is dictionary encoded.
  public var dictionary: org_apache_arrow_flatbuf_DictionaryEncoding? {
    let o = _accessor.offset(VTOFFSET.dictionary.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_DictionaryEncoding(
        _accessor.bb, o: _accessor.indirect(o + _accessor.position))
  }
  ///  children apply only to nested data types like Struct, List and Union. For
  ///  primitive types children will have length 0.
  public var hasChildren: Bool {
    let o = _accessor.offset(VTOFFSET.children.v)
    return o == 0 ? false : true
  }
  public var childrenCount: Int32 {
    let o = _accessor.offset(VTOFFSET.children.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func children(at index: Int32) -> org_apache_arrow_flatbuf_Field? {
    let o = _accessor.offset(VTOFFSET.children.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_Field(
        _accessor.bb, o: _accessor.indirect(_accessor.vector(at: o) + index * 4))
  }
  ///  User-defined metadata
  public var hasCustomMetadata: Bool {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0 ? false : true
  }
  public var customMetadataCount: Int32 {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func customMetadata(at index: Int32) -> org_apache_arrow_flatbuf_KeyValue? {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_KeyValue(
        _accessor.bb, o: _accessor.indirect(_accessor.vector(at: o) + index * 4))
  }
  public static func startField(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 7)
  }
  public static func add(name: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: name, at: VTOFFSET.name.p)
  }
  public static func add(nullable: Bool, _ fbb: inout FlatBufferBuilder) {
    fbb.add(
      element: nullable, def: false,
      at: VTOFFSET.nullable.p)
  }
  public static func add(typeType: org_apache_arrow_flatbuf_Type_, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: typeType.rawValue, def: 0, at: VTOFFSET.typeType.p)
  }
  public static func add(type: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: type, at: VTOFFSET.type.p)
  }
  public static func add(dictionary: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: dictionary, at: VTOFFSET.dictionary.p)
  }
  public static func addVectorOf(children: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: children, at: VTOFFSET.children.p)
  }
  public static func addVectorOf(customMetadata: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: customMetadata, at: VTOFFSET.customMetadata.p)
  }
  public static func endField(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createField(
    _ fbb: inout FlatBufferBuilder,
    nameOffset name: Offset = Offset(),
    nullable: Bool = false,
    typeType: org_apache_arrow_flatbuf_Type_ = .none_,
    typeOffset type: Offset = Offset(),
    dictionaryOffset dictionary: Offset = Offset(),
    childrenVectorOffset children: Offset = Offset(),
    customMetadataVectorOffset customMetadata: Offset = Offset()
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Field.startField(&fbb)
    org_apache_arrow_flatbuf_Field.add(name: name, &fbb)
    org_apache_arrow_flatbuf_Field.add(nullable: nullable, &fbb)
    org_apache_arrow_flatbuf_Field.add(typeType: typeType, &fbb)
    org_apache_arrow_flatbuf_Field.add(type: type, &fbb)
    org_apache_arrow_flatbuf_Field.add(dictionary: dictionary, &fbb)
    org_apache_arrow_flatbuf_Field.addVectorOf(children: children, &fbb)
    org_apache_arrow_flatbuf_Field.addVectorOf(customMetadata: customMetadata, &fbb)
    return org_apache_arrow_flatbuf_Field.endField(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.name.p, fieldName: "name", required: false, type: ForwardOffset<String>.self)
    try _v.visit(
      field: VTOFFSET.nullable.p, fieldName: "nullable", required: false, type: Bool.self)
    try _v.visit(
      unionKey: VTOFFSET.typeType.p, unionField: VTOFFSET.type.p, unionKeyName: "typeType",
      fieldName: "type", required: false,
      completion: { (verifier, key: org_apache_arrow_flatbuf_Type_, pos) in
        switch key {
        case .none_:
          break  // NOTE - SWIFT doesnt support none
        case .null:
          try ForwardOffset<org_apache_arrow_flatbuf_Null>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Null.self)
        case .int:
          try ForwardOffset<org_apache_arrow_flatbuf_Int>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Int.self)
        case .floatingpoint:
          try ForwardOffset<org_apache_arrow_flatbuf_FloatingPoint>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_FloatingPoint.self)
        case .binary:
          try ForwardOffset<org_apache_arrow_flatbuf_Binary>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Binary.self)
        case .utf8:
          try ForwardOffset<org_apache_arrow_flatbuf_Utf8>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Utf8.self)
        case .bool:
          try ForwardOffset<org_apache_arrow_flatbuf_Bool>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Bool.self)
        case .decimal:
          try ForwardOffset<org_apache_arrow_flatbuf_Decimal>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Decimal.self)
        case .date:
          try ForwardOffset<org_apache_arrow_flatbuf_Date>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Date.self)
        case .time:
          try ForwardOffset<org_apache_arrow_flatbuf_Time>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Time.self)
        case .timestamp:
          try ForwardOffset<org_apache_arrow_flatbuf_Timestamp>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Timestamp.self)
        case .interval:
          try ForwardOffset<org_apache_arrow_flatbuf_Interval>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Interval.self)
        case .list:
          try ForwardOffset<org_apache_arrow_flatbuf_List>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_List.self)
        case .struct_:
          try ForwardOffset<org_apache_arrow_flatbuf_Struct_>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Struct_.self)
        case .union:
          try ForwardOffset<org_apache_arrow_flatbuf_Union>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Union.self)
        case .fixedsizebinary:
          try ForwardOffset<org_apache_arrow_flatbuf_FixedSizeBinary>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_FixedSizeBinary.self)
        case .fixedsizelist:
          try ForwardOffset<org_apache_arrow_flatbuf_FixedSizeList>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_FixedSizeList.self)
        case .map:
          try ForwardOffset<org_apache_arrow_flatbuf_Map>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Map.self)
        case .duration:
          try ForwardOffset<org_apache_arrow_flatbuf_Duration>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Duration.self)
        case .largebinary:
          try ForwardOffset<org_apache_arrow_flatbuf_LargeBinary>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_LargeBinary.self)
        case .largeutf8:
          try ForwardOffset<org_apache_arrow_flatbuf_LargeUtf8>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_LargeUtf8.self)
        case .largelist:
          try ForwardOffset<org_apache_arrow_flatbuf_LargeList>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_LargeList.self)
        case .runendencoded:
          try ForwardOffset<org_apache_arrow_flatbuf_RunEndEncoded>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_RunEndEncoded.self)
        }
      })
    try _v.visit(
      field: VTOFFSET.dictionary.p, fieldName: "dictionary", required: false,
      type: ForwardOffset<org_apache_arrow_flatbuf_DictionaryEncoding>.self)
    try _v.visit(
      field: VTOFFSET.children.p, fieldName: "children", required: false,
      type: ForwardOffset<
        Vector<ForwardOffset<org_apache_arrow_flatbuf_Field>, org_apache_arrow_flatbuf_Field>
      >.self)
    try _v.visit(
      field: VTOFFSET.customMetadata.p, fieldName: "customMetadata", required: false,
      type: ForwardOffset<
        Vector<ForwardOffset<org_apache_arrow_flatbuf_KeyValue>, org_apache_arrow_flatbuf_KeyValue>
      >.self)
    _v.finish()
  }
}

///  ----------------------------------------------------------------------
///  A Schema describes the columns in a row batch
/// @nodoc
public struct org_apache_arrow_flatbuf_Schema: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsSchema(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Schema {
    return org_apache_arrow_flatbuf_Schema(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case endianness = 4
    case fields = 6
    case customMetadata = 8
    case features = 10
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  endianness of the buffer
  ///  it is Little Endian by default
  ///  if endianness doesn't match the underlying system then the vectors need to be converted
  public var endianness: org_apache_arrow_flatbuf_Endianness {
    let o = _accessor.offset(VTOFFSET.endianness.v)
    return o == 0
      ? .little
      : org_apache_arrow_flatbuf_Endianness(rawValue: _accessor.readBuffer(of: Int16.self, at: o))
        ?? .little
  }
  public var hasFields: Bool {
    let o = _accessor.offset(VTOFFSET.fields.v)
    return o == 0 ? false : true
  }
  public var fieldsCount: Int32 {
    let o = _accessor.offset(VTOFFSET.fields.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func fields(at index: Int32) -> org_apache_arrow_flatbuf_Field? {
    let o = _accessor.offset(VTOFFSET.fields.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_Field(
        _accessor.bb, o: _accessor.indirect(_accessor.vector(at: o) + index * 4))
  }
  public var hasCustomMetadata: Bool {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0 ? false : true
  }
  public var customMetadataCount: Int32 {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func customMetadata(at index: Int32) -> org_apache_arrow_flatbuf_KeyValue? {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_KeyValue(
        _accessor.bb, o: _accessor.indirect(_accessor.vector(at: o) + index * 4))
  }
  ///  Features used in the stream/file.
  public var hasFeatures: Bool {
    let o = _accessor.offset(VTOFFSET.features.v)
    return o == 0 ? false : true
  }
  public var featuresCount: Int32 {
    let o = _accessor.offset(VTOFFSET.features.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func features(at index: Int32) -> org_apache_arrow_flatbuf_Feature? {
    let o = _accessor.offset(VTOFFSET.features.v)
    return o == 0
      ? org_apache_arrow_flatbuf_Feature.unused
      : org_apache_arrow_flatbuf_Feature(
        rawValue: _accessor.bb.read(def: Int64.self, position: Int(_accessor.vector(at: o) + index * 8)))
  }
  public static func startSchema(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 4)
  }
  public static func add(
    endianness: org_apache_arrow_flatbuf_Endianness, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: endianness.rawValue, def: 0, at: VTOFFSET.endianness.p) }
  public static func addVectorOf(fields: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: fields, at: VTOFFSET.fields.p)
  }
  public static func addVectorOf(customMetadata: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: customMetadata, at: VTOFFSET.customMetadata.p)
  }
  public static func addVectorOf(features: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: features, at: VTOFFSET.features.p)
  }
  public static func endSchema(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createSchema(
    _ fbb: inout FlatBufferBuilder,
    endianness: org_apache_arrow_flatbuf_Endianness = .little,
    fieldsVectorOffset fields: Offset = Offset(),
    customMetadataVectorOffset customMetadata: Offset = Offset(),
    featuresVectorOffset features: Offset = Offset()
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Schema.startSchema(&fbb)
    org_apache_arrow_flatbuf_Schema.add(endianness: endianness, &fbb)
    org_apache_arrow_flatbuf_Schema.addVectorOf(fields: fields, &fbb)
    org_apache_arrow_flatbuf_Schema.addVectorOf(customMetadata: customMetadata, &fbb)
    org_apache_arrow_flatbuf_Schema.addVectorOf(features: features, &fbb)
    return org_apache_arrow_flatbuf_Schema.endSchema(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.endianness.p, fieldName: "endianness", required: false,
      type: org_apache_arrow_flatbuf_Endianness.self)
    try _v.visit(
      field: VTOFFSET.fields.p, fieldName: "fields", required: false,
      type: ForwardOffset<
        Vector<ForwardOffset<org_apache_arrow_flatbuf_Field>, org_apache_arrow_flatbuf_Field>
      >.self)
    try _v.visit(
      field: VTOFFSET.customMetadata.p, fieldName: "customMetadata", required: false,
      type: ForwardOffset<
        Vector<ForwardOffset<org_apache_arrow_flatbuf_KeyValue>, org_apache_arrow_flatbuf_KeyValue>
      >.self)
    try _v.visit(
      field: VTOFFSET.features.p, fieldName: "features", required: false,
      type: ForwardOffset<
        Vector<org_apache_arrow_flatbuf_Feature, org_apache_arrow_flatbuf_Feature>
      >.self)
    _v.finish()
  }
}
