/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.NetworkChannel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.net.openssl.ciphers.Group;
import org.apache.tomcat.util.net.openssl.ciphers.SignatureScheme;

public abstract class AbstractJsseEndpoint<S, U>
extends AbstractEndpoint<S, U> {
    static final ThreadLocal<List<String>> clientRequestedProtocolsThreadLocal = new ThreadLocal();
    static final ThreadLocal<List<Group>> clientSupportedGroupsThreadLocal = new ThreadLocal();
    static final ThreadLocal<List<SignatureScheme>> clientSignatureSchemesThreadLocal = new ThreadLocal();
    private String sslImplementationName = null;
    private int sniParseLimit = 65536;
    private SSLImplementation sslImplementation = null;

    public String getSslImplementationName() {
        return this.sslImplementationName;
    }

    public void setSslImplementationName(String s) {
        this.sslImplementationName = s;
    }

    public SSLImplementation getSslImplementation() {
        return this.sslImplementation;
    }

    public int getSniParseLimit() {
        return this.sniParseLimit;
    }

    public void setSniParseLimit(int sniParseLimit) {
        this.sniParseLimit = sniParseLimit;
    }

    protected void initialiseSsl() throws Exception {
        if (this.isSSLEnabled()) {
            this.sslImplementation = SSLImplementation.getInstance(this.getSslImplementationName());
            for (SSLHostConfig sslHostConfig : this.sslHostConfigs.values()) {
                this.createSSLContext(sslHostConfig);
            }
            if (this.sslHostConfigs.get(this.getDefaultSSLHostConfigName()) == null) {
                throw new IllegalArgumentException(sm.getString("endpoint.noSslHostConfig", this.getDefaultSSLHostConfigName(), this.getName()));
            }
        }
    }

    @Override
    protected void createSSLContext(SSLHostConfig sslHostConfig) throws IllegalArgumentException {
        boolean firstCertificate = true;
        for (SSLHostConfigCertificate certificate : sslHostConfig.getCertificates(true)) {
            SSLUtil sslUtil = this.sslImplementation.getSSLUtil(certificate);
            if (firstCertificate) {
                firstCertificate = false;
                sslHostConfig.setEnabledProtocols(sslUtil.getEnabledProtocols());
                sslHostConfig.setEnabledCiphers(sslUtil.getEnabledCiphers());
            }
            SSLContext sslContext = certificate.getSslContext();
            SSLContext sslContextGenerated = certificate.getSslContextGenerated();
            if (sslContext == null || sslContext == sslContextGenerated) {
                try {
                    sslContext = sslUtil.createSSLContext(this.negotiableProtocols);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(sm.getString("endpoint.errorCreatingSSLContext"), e);
                }
                certificate.setSslContextGenerated(sslContext);
            }
            this.logCertificate(certificate);
        }
    }

    protected SSLEngine createSSLEngine(String sniHostName, List<Cipher> clientRequestedCiphers, List<String> clientRequestedApplicationProtocols) {
        SSLHostConfig sslHostConfig;
        SSLHostConfigCertificate certificate;
        SSLContext sslContext;
        List<SignatureScheme> clientSignatureSchemes;
        List<Group> clientSupportedGroups;
        List<String> clientRequestedProtocols = clientRequestedProtocolsThreadLocal.get();
        if (clientRequestedProtocols == null) {
            clientRequestedProtocols = new ArrayList<String>();
        }
        if ((clientSupportedGroups = clientSupportedGroupsThreadLocal.get()) == null) {
            clientSupportedGroups = new ArrayList<Group>();
        }
        if ((clientSignatureSchemes = clientSignatureSchemesThreadLocal.get()) == null) {
            clientSignatureSchemes = new ArrayList<SignatureScheme>();
        }
        if ((sslContext = (certificate = this.selectCertificate(sslHostConfig = this.getSSLHostConfig(sniHostName), clientRequestedCiphers, clientRequestedProtocols, clientSignatureSchemes)).getSslContext()) == null) {
            throw new IllegalStateException(sm.getString("endpoint.jsse.noSslContext", sniHostName));
        }
        SSLEngine engine = sslContext.createSSLEngine();
        engine.setUseClientMode(false);
        engine.setEnabledCipherSuites(sslHostConfig.getEnabledCiphers());
        engine.setEnabledProtocols(sslHostConfig.getEnabledProtocols());
        SSLParameters sslParameters = engine.getSSLParameters();
        sslParameters.setUseCipherSuitesOrder(sslHostConfig.getHonorCipherOrder());
        if (clientRequestedApplicationProtocols != null && !clientRequestedApplicationProtocols.isEmpty() && !this.negotiableProtocols.isEmpty()) {
            ArrayList commonProtocols = new ArrayList(this.negotiableProtocols);
            commonProtocols.retainAll(clientRequestedApplicationProtocols);
            if (!commonProtocols.isEmpty()) {
                String[] commonProtocolsArray = commonProtocols.toArray(new String[0]);
                sslParameters.setApplicationProtocols(commonProtocolsArray);
            }
        }
        if (JreCompat.isJre20Available()) {
            ArrayList<String> supportedGroups = new ArrayList<String>();
            LinkedHashSet<Group> serverSupportedGroups = sslHostConfig.getGroupList();
            if (serverSupportedGroups != null) {
                if (!clientSupportedGroups.isEmpty()) {
                    for (Group group : clientSupportedGroups) {
                        if (!serverSupportedGroups.contains((Object)group)) continue;
                        supportedGroups.add(group.toString());
                    }
                } else {
                    for (Group group : serverSupportedGroups) {
                        supportedGroups.add(group.toString());
                    }
                }
                JreCompat.getInstance().setNamedGroupsMethod(sslParameters, supportedGroups.toArray(new String[0]));
            } else if (!clientSupportedGroups.isEmpty()) {
                for (Group group : clientSupportedGroups) {
                    supportedGroups.add(group.toString());
                }
                JreCompat.getInstance().setNamedGroupsMethod(sslParameters, supportedGroups.toArray(new String[0]));
            }
        }
        switch (sslHostConfig.getCertificateVerification()) {
            case NONE: {
                sslParameters.setNeedClientAuth(false);
                sslParameters.setWantClientAuth(false);
                break;
            }
            case OPTIONAL: 
            case OPTIONAL_NO_CA: {
                sslParameters.setWantClientAuth(true);
                break;
            }
            case REQUIRED: {
                sslParameters.setNeedClientAuth(true);
            }
        }
        engine.setSSLParameters(sslParameters);
        return engine;
    }

    private SSLHostConfigCertificate selectCertificate(SSLHostConfig sslHostConfig, List<Cipher> clientCiphers, List<String> clientRequestedProtocols, List<SignatureScheme> clientSignatureSchemes) {
        Set<SSLHostConfigCertificate> certificates = sslHostConfig.getCertificates(true);
        if (certificates.size() == 1) {
            return certificates.iterator().next();
        }
        if (clientRequestedProtocols.contains("TLSv1.3") && sslHostConfig.getProtocols().contains("TLSv1.3")) {
            for (SignatureScheme signatureScheme : clientSignatureSchemes) {
                for (SSLHostConfigCertificate certificate : certificates) {
                    if (!certificate.getType().isCompatibleWith(signatureScheme)) continue;
                    return certificate;
                }
            }
        }
        LinkedHashSet<Cipher> serverCiphers = sslHostConfig.getCipherList();
        ArrayList<Cipher> candidateCiphers = new ArrayList<Cipher>();
        if (sslHostConfig.getHonorCipherOrder()) {
            candidateCiphers.addAll(serverCiphers);
            candidateCiphers.retainAll(clientCiphers);
        } else {
            candidateCiphers.addAll(clientCiphers);
            candidateCiphers.retainAll(serverCiphers);
        }
        for (Cipher candidate : candidateCiphers) {
            for (SSLHostConfigCertificate certificate : certificates) {
                if (!certificate.getType().isCompatibleWith(candidate.getAu())) continue;
                return certificate;
            }
        }
        return certificates.iterator().next();
    }

    @Override
    public void unbind() throws Exception {
        for (SSLHostConfig sslHostConfig : this.sslHostConfigs.values()) {
            for (SSLHostConfigCertificate certificate : sslHostConfig.getCertificates()) {
                certificate.setSslContextGenerated(null);
            }
        }
    }

    protected abstract NetworkChannel getServerSocket();

    @Override
    protected final InetSocketAddress getLocalAddress() throws IOException {
        NetworkChannel serverSock = this.getServerSocket();
        if (serverSock == null) {
            return null;
        }
        SocketAddress sa = serverSock.getLocalAddress();
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }
}

