/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.smallrye.metrics.legacyapi.MeterHolder;
import io.smallrye.metrics.legacyapi.MetricDescriptor;
import io.smallrye.metrics.legacyapi.MpMetadata;
import io.smallrye.metrics.legacyapi.SnapshotAdapter;
import io.smallrye.metrics.setup.config.DefaultBucketConfiguration;
import io.smallrye.metrics.setup.config.HistogramBucketConfiguration;
import io.smallrye.metrics.setup.config.HistogramBucketMaxConfiguration;
import io.smallrye.metrics.setup.config.HistogramBucketMinConfiguration;
import io.smallrye.metrics.setup.config.MetricPercentileConfiguration;
import io.smallrye.metrics.setup.config.MetricsConfigurationManager;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Snapshot;

class HistogramAdapter
implements Histogram,
MeterHolder {
    private static final String CLASS_NAME = HistogramAdapter.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private static final int PRECISION = ConfigProvider.getConfig().getOptionalValue("mp.metrics.smallrye.histogram.precision", Integer.class).orElse(3);
    DistributionSummary globalCompositeSummary;

    HistogramAdapter() {
    }

    public HistogramAdapter register(MpMetadata metadata, MetricDescriptor metricInfo, String scope, Tag ... globalTags) {
        if (this.globalCompositeSummary == null || metadata.cleanDirtyMetadata()) {
            MetricPercentileConfiguration percentilesConfig = MetricsConfigurationManager.getInstance().getPercentilesConfiguration(metadata.getName());
            HistogramBucketConfiguration bucketsConfig = MetricsConfigurationManager.getInstance().getHistogramBucketConfiguration(metadata.getName());
            DefaultBucketConfiguration defaultBucketConfig = MetricsConfigurationManager.getInstance().getDefaultBucketConfiguration(metadata.getName());
            HashSet<Tag> tagsSet = new HashSet<Tag>();
            for (Tag t : metricInfo.tags()) {
                tagsSet.add(t);
            }
            if (globalTags != null) {
                for (Tag t : globalTags) {
                    tagsSet.add(t);
                }
            }
            tagsSet.add(Tag.of((String)"mp_scope", (String)scope));
            DistributionSummary.Builder builder = DistributionSummary.builder((String)metricInfo.name()).description(metadata.getDescription()).baseUnit(metadata.getUnit()).tags(tagsSet).percentilePrecision(Integer.valueOf(PRECISION));
            if (percentilesConfig != null && percentilesConfig.getValues() != null && ((Double[])percentilesConfig.getValues()).length > 0) {
                double[] vals = Stream.of((Double[])percentilesConfig.getValues()).mapToDouble(Double::doubleValue).toArray();
                builder = builder.publishPercentiles(vals);
            } else if (percentilesConfig == null || percentilesConfig.getValues() != null || !percentilesConfig.isDisabled()) {
                builder = builder.publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999});
            }
            if (bucketsConfig != null && ((Double[])bucketsConfig.getValues()).length > 0) {
                double[] vals = Stream.of((Double[])bucketsConfig.getValues()).mapToDouble(Double::doubleValue).toArray();
                builder = builder.serviceLevelObjectives(vals);
            }
            if (defaultBucketConfig != null && defaultBucketConfig.isEnabled()) {
                HistogramBucketMinConfiguration defaultBucketMinConfig;
                builder = builder.publishPercentileHistogram(Boolean.valueOf(defaultBucketConfig.isEnabled()));
                HistogramBucketMaxConfiguration defaultBucketMaxConfig = MetricsConfigurationManager.getInstance().getDefaultHistogramMaxBucketConfiguration(metadata.getName());
                if (defaultBucketMaxConfig != null && defaultBucketMaxConfig.getValue() != null && (Double)defaultBucketMaxConfig.getValue() != Double.NaN) {
                    builder = builder.maximumExpectedValue((Double)defaultBucketMaxConfig.getValue());
                }
                if ((defaultBucketMinConfig = MetricsConfigurationManager.getInstance().getDefaultHistogramMinBucketConfiguration(metadata.getName())) != null && defaultBucketMinConfig.getValue() != null && (Double)defaultBucketMinConfig.getValue() != Double.NaN) {
                    builder = builder.minimumExpectedValue((Double)defaultBucketMinConfig.getValue());
                }
            }
            this.globalCompositeSummary = builder.register((MeterRegistry)Metrics.globalRegistry);
        }
        return this;
    }

    public void update(int i) {
        this.globalCompositeSummary.record((double)i);
    }

    public void update(long l) {
        this.globalCompositeSummary.record((double)l);
    }

    public long getCount() {
        return this.globalCompositeSummary.count();
    }

    public long getSum() {
        return (long)this.globalCompositeSummary.takeSnapshot().total();
    }

    public Snapshot getSnapshot() {
        return new SnapshotAdapter(this.globalCompositeSummary.takeSnapshot());
    }

    @Override
    public Meter getMeter() {
        return this.globalCompositeSummary;
    }

    static {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, CLASS_NAME, null, "Resolved MicroProfile Config value for mp.metrics.smallrye.histogram.precision as \"{0}\"", PRECISION);
        }
    }
}

