/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.lang;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;

public class StringCharArrayAccessor {
    static volatile boolean enabled = !Boolean.getBoolean("oam.stringchararrayaccessor.disabled");
    static volatile boolean jdk7String = false;
    static Field valueField;
    static Field countField;
    static Field offsetField;

    private StringCharArrayAccessor() {
    }

    public static void writeStringAsCharArray(Writer writer, String str) throws IOException {
        StringCharArrayAccessor.writeStringAsCharArray(writer, str, 0, str.length());
    }

    public static void writeStringAsCharArray(Writer writer, String str, int off, int len) throws IOException {
        char[] value;
        if (!enabled) {
            StringCharArrayAccessor.writeStringFallback(writer, str, off, len);
            return;
        }
        int internalOffset = 0;
        try {
            value = (char[])valueField.get(str);
            if (!jdk7String) {
                internalOffset = offsetField.getInt(str);
            }
        }
        catch (Exception e) {
            StringCharArrayAccessor.handleError(e);
            StringCharArrayAccessor.writeStringFallback(writer, str, off, len);
            return;
        }
        writer.write(value, internalOffset + off, len);
    }

    private static void writeStringFallback(Writer writer, String str, int off, int len) throws IOException {
        writer.write(str, off, len);
    }

    static char[] getValue(String str) {
        if (!enabled) {
            return StringCharArrayAccessor.getValueFallback(str);
        }
        char[] value = null;
        int internalOffset = 0;
        try {
            value = (char[])valueField.get(str);
            if (!jdk7String) {
                internalOffset = offsetField.getInt(str);
            }
        }
        catch (Exception e) {
            StringCharArrayAccessor.handleError(e);
        }
        if (value != null && internalOffset == 0) {
            return value;
        }
        return StringCharArrayAccessor.getValueFallback(str);
    }

    static char[] getValueFallback(String str) {
        return str.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createString(char[] charBuf) {
        if (!enabled) {
            return StringCharArrayAccessor.createStringFallback(charBuf);
        }
        String str = "";
        try {
            String string = str;
            synchronized (string) {
                valueField.set(str, charBuf);
                if (!jdk7String) {
                    countField.set(str, charBuf.length);
                }
            }
            string = str;
            synchronized (string) {
                if (str.length() != charBuf.length) {
                    throw new IllegalStateException("Fast java.lang.String construction failed.");
                }
            }
        }
        catch (Exception e) {
            StringCharArrayAccessor.handleError(e);
            str = StringCharArrayAccessor.createStringFallback(charBuf);
        }
        return str;
    }

    private static String createStringFallback(char[] charBuf) {
        return new String(charBuf);
    }

    private static synchronized void handleError(Exception e) {
        enabled = false;
        valueField = null;
        countField = null;
        offsetField = null;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    static {
        if (enabled) {
            try {
                valueField = String.class.getDeclaredField("value");
                valueField.setAccessible(true);
            }
            catch (Exception e) {
                enabled = false;
                StringCharArrayAccessor.handleError(e);
            }
        }
        if (enabled) {
            try {
                countField = String.class.getDeclaredField("count");
                countField.setAccessible(true);
                offsetField = String.class.getDeclaredField("offset");
                offsetField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                jdk7String = true;
            }
            catch (Exception e) {
                enabled = false;
                StringCharArrayAccessor.handleError(e);
            }
        }
    }
}

