/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDiskData;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.TextCache;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDiskData
extends RowStoreAVL {
    TextCache cache;
    RowOutputInterface rowOut;
    AtomicInteger accessCount;

    public RowStoreAVLDiskData(Table table) {
        this.database = table.database;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    public Object[] getData(RowAVLDiskData rowAVLDiskData) {
        this.cache.writeLock.lock();
        try {
            this.cache.get(rowAVLDiskData, (PersistentStore)this, false);
            Object[] objectArray = rowAVLDiskData.getData();
            return objectArray;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    public int getNextAccessCount() {
        return this.accessCount.incrementAndGet();
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
        return cachedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
        this.cache.writeLock.lock();
        try {
            int n = cachedObject.getRealSize(this.rowOut);
            cachedObject.setStorageSize(n);
            long l = this.tableSpace.getFilePosition(n);
            cachedObject.setPos(l);
            if (bl) {
                RowAction.addInsertAction(session, this.table, this, (Row)cachedObject);
            }
            this.cache.add(cachedObject, false);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        RowAVLDiskData rowAVLDiskData = new RowAVLDiskData(this, this.table, rowInputInterface);
        this.cache.cache.put(rowAVLDiskData);
        return rowAVLDiskData;
    }

    @Override
    public CachedObject get(CachedObject cachedObject, RowInputInterface rowInputInterface) {
        Object[] objectArray = rowInputInterface.readData(this.table.getColumnTypes());
        ((RowAVLDiskData)cachedObject).setData(objectArray);
        return cachedObject;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVLDiskData rowAVLDiskData = new RowAVLDiskData((PersistentStore)this, this.table, (Object[])object);
        this.add(session, rowAVLDiskData, bl);
        return rowAVLDiskData;
    }

    @Override
    public void indexRow(Session session, Row row) {
        super.indexRow(session, row);
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void removeAll() {
        this.destroyIndexes();
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject cachedObject) {
        this.cache.remove(cachedObject);
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[n];
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
        try {
            this.cache.saveRow(cachedObject);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void postCommitAction(Session session, RowAction rowAction) {
        if (rowAction.getType() == 3 && !rowAction.isDeleteComplete()) {
            rowAction.setDeleteComplete();
            Row row = rowAction.getRow();
            if (row == null) {
                row = (Row)this.get(rowAction.getPos(), false);
            }
            this.delete(session, row);
            this.remove(row);
        }
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                this.cache.removePersistence(row);
                break;
            }
            case 1: {
                this.commitPersistence(row);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 3: {
                throw Error.runtimeError(201, "RowStore");
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.remove(row);
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        this.cache = (TextCache)dataFileCache;
        this.tableSpace = dataFileCache.spaceManager.getTableSpace(7);
        this.accessCount = dataFileCache.getAccessCount();
        this.rowOut = dataFileCache.rowOut;
    }

    @Override
    public void release() {
        this.destroyIndexes();
        this.table.database.logger.textTableManager.closeTextCache((Table)this.table);
        this.cache = null;
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

