/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.media;

import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class Track
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private Kind kind;
    private String label;
    private boolean defaultTrack;
    private Locale srclang;
    private final ResourceReference resourceReference;
    private final String url;
    private PageParameters pageParameters;

    public Track(String id) {
        this(id, null, null, null, null);
    }

    public Track(String id, IModel<?> model) {
        this(id, model, null, null, null);
    }

    public Track(String id, ResourceReference resourceReference) {
        this(id, null, null, null, resourceReference);
    }

    public Track(String id, IModel<?> model, ResourceReference resourceReference) {
        this(id, model, null, null, resourceReference);
    }

    public Track(String id, ResourceReference resourceReference, PageParameters pageParameters) {
        this(id, null, null, pageParameters, resourceReference);
    }

    public Track(String id, IModel<?> model, ResourceReference resourceReference, PageParameters pageParameters) {
        this(id, model, null, pageParameters, resourceReference);
    }

    public Track(String id, String url) {
        this(id, null, url, null, null);
    }

    public Track(String id, IModel<?> model, String url) {
        this(id, model, url, null, null);
    }

    private Track(String id, IModel<?> model, String url, PageParameters pageParameters, ResourceReference resourceReference) {
        super(id, model);
        this.url = url;
        this.pageParameters = pageParameters;
        this.resourceReference = resourceReference;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        Locale _srclang;
        String _label;
        this.checkComponentTag(tag, "track");
        super.onComponentTag(tag);
        if (this.resourceReference != null) {
            tag.put("src", RequestCycle.get().urlFor(this.resourceReference, this.pageParameters));
        } else if (this.url != null) {
            tag.put("src", this.url);
        }
        Kind _kind = this.getKind();
        if (_kind != null) {
            tag.put("kind", _kind.getRealName());
        }
        if ((_label = this.getLabel()) != null) {
            tag.put("label", _label);
        }
        if (this.defaultTrack) {
            tag.put("default", "default");
        }
        if ((_srclang = this.getSrclang()) != null) {
            tag.put("srclang", _srclang.getLanguage());
        } else if (this.resourceReference != null && this.resourceReference.getLocale() != null) {
            tag.put("srclang", this.resourceReference.getLocale().getLanguage());
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isDefaultTrack() {
        return this.defaultTrack;
    }

    public void setDefaultTrack(Boolean defaultTrack) {
        this.defaultTrack = defaultTrack;
    }

    public Locale getSrclang() {
        return this.srclang;
    }

    public void setSrclang(Locale srclang) {
        this.srclang = srclang;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public void setPageParameters(PageParameters pageParameters) {
        this.pageParameters = pageParameters;
    }

    public static enum Kind {
        SUBTITLES("subtitles"),
        CAPTIONS("captions"),
        DESCRIPTIONS("descriptions"),
        CHAPTERS("chapters"),
        METADATA("metadata");

        private String realName;

        private Kind(String realName) {
            this.realName = realName;
        }

        public String getRealName() {
            return this.realName;
        }
    }
}

